/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.item;

import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicList;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicSong;
import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ItemMusicCD
extends Item {
    public static final String SONG_INFO_TAG = "NetMusicSongInfo";

    public ItemMusicCD() {
        super(new Item.Properties().m_41491_(InitItems.TAB));
    }

    public static SongInfo getSongInfo(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() == InitItems.MUSIC_CD.get() && (tag = stack.m_41783_()) != null && tag.m_128425_(SONG_INFO_TAG, 10)) {
            CompoundTag infoTag = tag.m_128469_(SONG_INFO_TAG);
            return SongInfo.deserializeNBT(infoTag);
        }
        return null;
    }

    public static ItemStack setSongInfo(SongInfo info, ItemStack stack) {
        if (stack.m_41720_() == InitItems.MUSIC_CD.get()) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            CompoundTag songInfoTag = new CompoundTag();
            SongInfo.serializeNBT(info, songInfoTag);
            tag.m_128365_(SONG_INFO_TAG, (Tag)songInfoTag);
            stack.m_41751_(tag);
        }
        return stack;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            items.add((Object)new ItemStack((ItemLike)InitItems.MUSIC_CD.get()));
            for (SongInfo info : MusicListManage.SONGS) {
                ItemStack stack = new ItemStack((ItemLike)this);
                items.add((Object)ItemMusicCD.setSongInfo(info, stack));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        if (info != null) {
            Object name = info.songName;
            if (info.vip) {
                name = (String)name + " \u00a74\u00a7l[VIP]";
            }
            return new TextComponent((String)name);
        }
        return super.m_7626_(stack);
    }

    private String getSongTime(int songTime) {
        int min = songTime / 60;
        int sec = songTime % 60;
        String minStr = min <= 9 ? "0" + min : "" + min;
        String secStr = sec <= 9 ? "0" + sec : "" + sec;
        return I18n.m_118938_((String)"tooltips.netmusic.cd.time.format", (Object[])new Object[]{minStr, secStr});
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        String prefix = "\u00a7a\u258d \u00a77";
        String delimiter = ": ";
        if (info != null) {
            String text;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.transName})) {
                text = "\u00a7a\u258d \u00a77" + I18n.m_118938_((String)"tooltips.netmusic.cd.trans_name", (Object[])new Object[0]) + ": \u00a76" + info.transName;
                tooltip.add((Component)new TextComponent(text));
            }
            if (info.artists != null && !info.artists.isEmpty()) {
                String artistNames = StringUtils.join(info.artists, (String)" | ");
                String text2 = "\u00a7a\u258d \u00a77" + I18n.m_118938_((String)"tooltips.netmusic.cd.artists", (Object[])new Object[0]) + ": \u00a73" + artistNames;
                tooltip.add((Component)new TextComponent(text2));
            }
            text = "\u00a7a\u258d \u00a77" + I18n.m_118938_((String)"tooltips.netmusic.cd.time", (Object[])new Object[0]) + ": \u00a75" + this.getSongTime(info.songTime);
            tooltip.add((Component)new TextComponent(text));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltips.netmusic.cd.empty").m_130940_(ChatFormatting.RED));
        }
    }

    public static class SongInfo {
        @SerializedName(value="url")
        public String songUrl;
        @SerializedName(value="name")
        public String songName;
        @SerializedName(value="time_second")
        public int songTime;
        @SerializedName(value="trans_name")
        public String transName = "";
        @SerializedName(value="vip")
        public boolean vip = false;
        @SerializedName(value="artists")
        public List<String> artists = Lists.newArrayList();

        public SongInfo(NetEaseMusicSong pojo) {
            NetEaseMusicSong.Song song = pojo.getSong();
            if (song != null) {
                this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", song.getId());
                this.songName = song.getName();
                this.songTime = song.getDuration() / 1000;
                this.transName = song.getTransName();
                this.vip = song.needVip();
                this.artists = song.getArtists();
            }
        }

        public SongInfo(NetEaseMusicList.Track track) {
            this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", track.getId());
            this.songName = track.getName();
            this.songTime = track.getDuration() / 1000;
            this.transName = track.getTransName();
            this.vip = track.needVip();
            this.artists = track.getArtists();
        }

        public SongInfo(CompoundTag tag) {
            this.songUrl = tag.m_128461_("url");
            this.songName = tag.m_128461_("name");
            this.songTime = tag.m_128451_("time");
            if (tag.m_128425_("trans_name", 8)) {
                this.transName = tag.m_128461_("trans_name");
            }
            if (tag.m_128425_("vip", 1)) {
                this.vip = tag.m_128471_("vip");
            }
            if (tag.m_128425_("artists", 9)) {
                ListTag tagList = tag.m_128437_("artists", 8);
                this.artists = Lists.newArrayList();
                tagList.forEach(nbt -> this.artists.add(nbt.m_7916_()));
            }
        }

        public static SongInfo deserializeNBT(CompoundTag tag) {
            return new SongInfo(tag);
        }

        public static void serializeNBT(SongInfo info, CompoundTag tag) {
            tag.m_128359_("url", info.songUrl);
            tag.m_128359_("name", info.songName);
            tag.m_128405_("time", info.songTime);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.transName})) {
                tag.m_128359_("trans_name", info.transName);
            }
            tag.m_128379_("vip", info.vip);
            if (info.artists != null && !info.artists.isEmpty()) {
                ListTag nbt = new ListTag();
                info.artists.forEach(name -> nbt.add((Object)StringTag.m_129297_((String)name)));
                tag.m_128365_("artists", (Tag)nbt);
            }
        }
    }
}

