/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.network.message;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.NetWorker;
import com.github.tartaricacid.netmusic.client.audio.NetMusicSound;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MusicToClientMessage {
    private static final String ERROR_404 = "http://music.163.com/404";
    private static final String MUSIC_163_URL = "https://music.163.com/";
    private final BlockPos pos;
    private final String url;
    private final int timeSecond;
    private final String songName;

    public MusicToClientMessage(BlockPos pos, String url, int timeSecond, String songName) {
        this.pos = pos;
        this.url = url;
        this.timeSecond = timeSecond;
        this.songName = songName;
    }

    public static MusicToClientMessage decode(FriendlyByteBuf buf) {
        return new MusicToClientMessage(BlockPos.m_122022_((long)buf.readLong()), buf.m_130277_(), buf.readInt(), buf.m_130277_());
    }

    public static void encode(MusicToClientMessage message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos.m_121878_());
        buf.m_130070_(message.url);
        buf.writeInt(message.timeSecond);
        buf.m_130070_(message.songName);
    }

    public static void handle(MusicToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> MusicToClientMessage.onHandle(message), Util.m_183991_()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(MusicToClientMessage message) {
        String url = message.url;
        if (message.url.startsWith(MUSIC_163_URL)) {
            try {
                url = NetWorker.getRedirectUrl(message.url, NetMusic.NET_EASE_WEB_API.getRequestPropertyData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (url != null && !url.equals(ERROR_404)) {
            MusicToClientMessage.playMusic(message, url);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playMusic(MusicToClientMessage message, String url) {
        try {
            URL urlFinal = new URL(url);
            NetMusicSound sound = new NetMusicSound(message.pos, urlFinal, message.timeSecond);
            Minecraft.m_91087_().m_18689_(() -> {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
                Minecraft.m_91087_().f_91065_.m_93055_((Component)new TextComponent(message.songName));
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

