/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell.detonator;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.detonator.DetonationEvent;

public interface IDetonationHandler {
    public static IDetonationHandler detonator(Entity entity) {
        return (IDetonationHandler)entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public static void performDetonation(Level world, Player player) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, e -> true);
    }

    public static void performDetonation(Level world, Player player, double range) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, e -> true);
    }

    public static void performDetonation(Level world, Player player, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, filter);
    }

    public static void performDetonation(Level world, Player player, double range, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, filter);
    }

    public static void performDetonation(Level world, Player player, Entity center) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, e -> true);
    }

    public static void performDetonation(Level world, Player player, Entity center, double range) {
        IDetonationHandler.performDetonation(world, player, center, range, e -> true);
    }

    public static void performDetonation(Level world, Player player, Entity center, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, filter);
    }

    public static void performDetonation(Level world, Player player, Entity center, double range, Predicate<Entity> filter) {
        List charges = world.m_6443_(Entity.class, center.m_142469_().m_82400_(range), entity -> {
            if (entity == null) {
                return false;
            }
            return entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).map(detonator -> {
                Vec3 locus = detonator.objectLocus();
                if (locus == null || locus.m_82531_(center.m_20185_(), center.m_20186_(), center.m_20189_()) > range * range) {
                    return false;
                }
                return filter == null || filter.test((Entity)entity);
            }).orElse(false);
        });
        List<IDetonationHandler> handlers = charges.stream().map(e -> (IDetonationHandler)e.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new)).collect(Collectors.toList());
        if (!MinecraftForge.EVENT_BUS.post((Event)new DetonationEvent(player, center, range, handlers)) && !handlers.isEmpty()) {
            for (IDetonationHandler handler : handlers) {
                handler.detonate();
            }
        }
    }

    default public Vec3 objectLocus() {
        return null;
    }

    public void detonate();
}

