/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.lib.LibResources;

@Mod.EventBusSubscriber(modid="psi", value={Dist.CLIENT})
public class BookSoundHandler {
    private static final int[] SECRET_CODE = new int[]{81, 85, 65, 84, 49, 48, 50, 52};
    private static int nextLetter = 0;
    private static int bookTime = 0;

    private static boolean isBookOpen() {
        return Objects.equals(PatchouliAPI.get().getOpenBookGui(), LibResources.PATCHOULI_BOOK);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent evt) {
        if (bookTime > 0) {
            --bookTime;
        }
        if (!BookSoundHandler.isBookOpen()) {
            nextLetter = 0;
        }
    }

    @SubscribeEvent
    public static void handleInput(InputEvent.KeyInputEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (evt.getModifiers() == 0 && evt.getAction() == 1 && BookSoundHandler.isBookOpen()) {
            if (bookTime == 0 && evt.getKey() == SECRET_CODE[nextLetter]) {
                if (++nextLetter >= SECRET_CODE.length) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)PsiSoundHandler.book, (float)1.0f));
                    nextLetter = 0;
                    bookTime = 320;
                }
            } else {
                nextLetter = 0;
            }
        }
    }
}

