/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.StringUtil;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.patchouli.PatchouliUtils;

public class SpellGridComponent
implements ICustomComponent {
    private transient int x;
    private transient int y;
    private transient boolean isDownscaled;
    private transient SpellGrid grid;
    public IVariable spell;
    public IVariable halfsize;

    public void build(int componentX, int componentY, int pageNum) {
        try {
            String spellstr = this.spell.asString("");
            if (StringUtil.m_14408_((String)spellstr)) {
                throw new IllegalArgumentException("Spell string is missing!");
            }
            CompoundTag cmp = TagParser.m_129359_((String)spellstr);
            Spell fromNBT = Spell.createFromNBT(cmp);
            if (fromNBT == null) {
                throw new IllegalArgumentException("Invalid spell string: " + this.spell);
            }
            this.grid = fromNBT.grid;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid spell string: " + this.spell, e);
        }
        this.isDownscaled = this.halfsize.asBoolean(false);
    }

    public void render(PoseStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        float scale = this.isDownscaled ? 0.5f : 1.0f;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ms.m_85836_();
        ms.m_85837_((double)this.x, (double)this.y, 0.0);
        ms.m_85841_(scale, scale, scale);
        this.grid.draw(ms, (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        float scaledSize = 18.0f * scale;
        int scaledHoverSize = (int)(16.0f * scale);
        SpellPiece[][] gridData = this.grid.gridData;
        for (int i = 0; i < gridData.length; ++i) {
            SpellPiece[] data = gridData[i];
            for (int j = 0; j < data.length; ++j) {
                SpellPiece piece = data[j];
                if (piece == null || !context.isAreaHovered(mouseX, mouseY, (int)((float)this.x + (float)i * scaledSize), (int)((float)this.y + (float)j * scaledSize), scaledHoverSize, scaledHoverSize)) continue;
                PatchouliUtils.setPieceTooltip(context, piece);
            }
        }
        ms.m_85849_();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.spell = (IVariable)lookup.apply(this.spell);
        this.halfsize = (IVariable)lookup.apply(this.halfsize);
    }
}

