/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileConjured;

public class BlockConjured
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    public static final BooleanProperty LIGHT = BooleanProperty.m_61465_((String)"light");
    public static final BooleanProperty BLOCK_UP = BooleanProperty.m_61465_((String)"block_up");
    public static final BooleanProperty BLOCK_DOWN = BooleanProperty.m_61465_((String)"block_down");
    public static final BooleanProperty BLOCK_NORTH = BooleanProperty.m_61465_((String)"block_north");
    public static final BooleanProperty BLOCK_SOUTH = BooleanProperty.m_61465_((String)"block_south");
    public static final BooleanProperty BLOCK_WEST = BooleanProperty.m_61465_((String)"block_west");
    public static final BooleanProperty BLOCK_EAST = BooleanProperty.m_61465_((String)"block_east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape LIGHT_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockConjured(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCK_SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        BlockEntity inWorld = worldIn.m_7702_(pos);
        if (inWorld instanceof TileConjured) {
            ((TileConjured)inWorld).doParticles();
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        BlockEntity inWorld = world.m_7702_(pos);
        if (inWorld instanceof TileConjured) {
            int color = Psi.proxy.getColorForColorizer(((TileConjured)inWorld).colorizer);
            return new float[]{(float)PsiRenderHelper.r(color) / 255.0f, (float)PsiRenderHelper.g(color) / 255.0f, (float)PsiRenderHelper.b(color) / 255.0f};
        }
        return null;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        world.m_7471_(pos, false);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, LIGHT, BLOCK_UP, BLOCK_DOWN, BLOCK_NORTH, BLOCK_SOUTH, BLOCK_WEST, BLOCK_EAST, WATERLOGGED});
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty prop = switch (facing) {
            default -> BLOCK_DOWN;
            case Direction.UP -> BLOCK_UP;
            case Direction.NORTH -> BLOCK_NORTH;
            case Direction.SOUTH -> BLOCK_SOUTH;
            case Direction.WEST -> BLOCK_WEST;
            case Direction.EAST -> BLOCK_EAST;
        };
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (state.m_60734_() == facingState.m_60734_() && state.m_61143_((Property)LIGHT) == facingState.m_61143_((Property)LIGHT) && state.m_61143_((Property)SOLID) == facingState.m_61143_((Property)SOLID)) {
            return (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIGHT) != false ? 15 : 0;
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SOLID) != false ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SOLID) != false ? Shapes.m_83144_() : LIGHT_SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileConjured(pos, state);
    }
}

