/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.AssembleCADEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ITileCADAssembler;
import vazkii.psi.api.cad.PostCADCraftEvent;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.container.ContainerCADAssembler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;

public class TileCADAssembler
extends BlockEntity
implements ITileCADAssembler,
MenuProvider {
    @ObjectHolder(value="psi:cad_assembler")
    public static BlockEntityType<TileCADAssembler> TYPE;
    private final IItemHandlerModifiable inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (0 < slot && slot < 6) {
                TileCADAssembler.this.clearCachedCAD();
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.m_41619_()) {
                return true;
            }
            if (slot == 0) {
                return ISocketable.isSocketable(stack);
            }
            if (slot < 6) {
                return stack.m_41720_() instanceof ICADComponent && ((ICADComponent)stack.m_41720_()).getComponentType(stack) == EnumCADComponent.values()[slot - 1];
            }
            return false;
        }
    };
    private final IItemHandler publicInv = new IItemHandler(){

        public int getSlots() {
            return TileCADAssembler.this.inventory.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileCADAssembler.this.inventory.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return TileCADAssembler.this.inventory.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileCADAssembler.this.inventory.isItemValid(slot, stack);
        }
    };
    private ItemStack cachedCAD;

    public TileCADAssembler(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.publicInv));
    }

    @Override
    public void clearCachedCAD() {
        this.cachedCAD = null;
    }

    @Override
    public ItemStack getCachedCAD(Player player) {
        ItemStack cad = this.cachedCAD;
        if (cad == null) {
            ItemStack assembly = this.getStackForComponent(EnumCADComponent.ASSEMBLY);
            if (!assembly.m_41619_()) {
                List<ItemStack> components = IntStream.range(1, 6).mapToObj(arg_0 -> ((IItemHandlerModifiable)this.inventory).getStackInSlot(arg_0)).collect(Collectors.toList());
                cad = ItemCAD.makeCADWithAssembly(assembly, components);
            } else {
                cad = ItemStack.f_41583_;
            }
            AssembleCADEvent assembling = new AssembleCADEvent(cad, this, player);
            MinecraftForge.EVENT_BUS.post((Event)assembling);
            cad = assembling.isCanceled() ? ItemStack.f_41583_ : assembling.getCad();
            this.cachedCAD = cad;
        }
        return cad;
    }

    @Override
    public int getComponentSlot(EnumCADComponent componentType) {
        return componentType.ordinal() + 1;
    }

    @Override
    public ItemStack getStackForComponent(EnumCADComponent componentType) {
        return this.inventory.getStackInSlot(this.getComponentSlot(componentType));
    }

    @Override
    public boolean setStackForComponent(EnumCADComponent componentType, ItemStack component) {
        ICADComponent componentItem;
        int slot = this.getComponentSlot(componentType);
        if (component.m_41619_()) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        if (component.m_41720_() instanceof ICADComponent && (componentItem = (ICADComponent)component.m_41720_()).getComponentType(component) == componentType) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getSocketableStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public ISocketable getSocketable() {
        return ISocketable.socketable(this.getSocketableStack());
    }

    @Override
    public boolean setSocketableStack(ItemStack stack) {
        if (stack.m_41619_() || ISocketable.isSocketable(stack)) {
            this.inventory.setStackInSlot(0, stack);
            return true;
        }
        return false;
    }

    @Override
    public void onCraftCAD(ItemStack cad) {
        MinecraftForge.EVENT_BUS.post((Event)new PostCADCraftEvent(cad, this));
        for (int i = 1; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, PsiSoundHandler.cadCreate, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isBulletSlotEnabled(int slot) {
        if (this.getSocketableStack().m_41619_()) {
            return false;
        }
        ISocketable socketable = this.getSocketable();
        return socketable != null && socketable.isSocketSlotAvailable(slot);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NonNullList items = NonNullList.m_122780_((int)this.inventory.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)items);
    }

    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.readPacketNBT(cmp);
    }

    public void readPacketNBT(@Nonnull CompoundTag tag) {
        if (tag.m_128451_("version") < 1) {
            ListTag items = tag.m_128437_("Items", 10);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
            LazyOptional socketable = LazyOptional.empty();
            for (int i = 0; i < items.size(); ++i) {
                if (i == 0) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)items.m_128728_(i));
                if (i == 6) {
                    this.setSocketableStack(stack);
                    if (stack.m_41619_()) continue;
                    socketable = stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
                    continue;
                }
                if (i == 1) {
                    this.setStackForComponent(EnumCADComponent.CORE, stack);
                    continue;
                }
                if (i == 2) {
                    this.setStackForComponent(EnumCADComponent.ASSEMBLY, stack);
                    continue;
                }
                if (i == 3) {
                    this.setStackForComponent(EnumCADComponent.SOCKET, stack);
                    continue;
                }
                if (i == 4) {
                    this.setStackForComponent(EnumCADComponent.BATTERY, stack);
                    continue;
                }
                if (i == 5) {
                    this.setStackForComponent(EnumCADComponent.DYE, stack);
                    continue;
                }
                int idx = i - 7;
                socketable.ifPresent(s -> s.setBulletInSocket(idx, stack));
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, e -> this.m_5995_());
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag cmp = new CompoundTag();
        this.m_183515_(cmp);
        return cmp;
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent(ModBlocks.cadAssembler.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCADAssembler(i, playerInventory, this);
    }
}

