/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.crafting.recipe.TrickRecipe;

public class DimensionTrickRecipe
extends TrickRecipe {
    public static final RecipeSerializer<DimensionTrickRecipe> SERIALIZER = new Serializer();
    private final ResourceKey<Level> dimensionKey;

    public DimensionTrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, ResourceKey<Level> dimensionKey) {
        super(id, piece, input, output, cad);
        this.dimensionKey = dimensionKey;
    }

    public DimensionTrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad, ResourceLocation dimensionKey) {
        this(id, piece, input, output, cad, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionKey));
    }

    @Override
    public boolean matches(RecipeWrapper inv, Level world) {
        return super.matches(inv, world) && world.m_46472_() == this.dimensionKey;
    }

    @Override
    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<DimensionTrickRecipe> {
        public DimensionTrickRecipe fromJson(ResourceLocation id, JsonObject json) {
            TrickRecipe recipe = (TrickRecipe)TrickRecipe.SERIALIZER.m_6729_(id, json);
            ResourceLocation dimensionId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"dimension"));
            return new DimensionTrickRecipe(id, recipe.getPiece(), recipe.getInput(), recipe.m_8043_(), recipe.getAssembly(), dimensionId);
        }

        @Nullable
        public DimensionTrickRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            TrickRecipe recipe = (TrickRecipe)TrickRecipe.SERIALIZER.m_8005_(id, buf);
            ResourceLocation dimensionId = buf.m_130281_();
            return new DimensionTrickRecipe(id, recipe.getPiece(), recipe.getInput(), recipe.m_8043_(), recipe.getAssembly(), dimensionId);
        }

        public void toNetwork(FriendlyByteBuf buf, DimensionTrickRecipe recipe) {
            TrickRecipe.SERIALIZER.m_6178_(buf, (Recipe)recipe);
            buf.m_130085_(recipe.dimensionKey.m_135782_());
        }
    }
}

