/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;

public class EntitySpellCircle
extends Entity
implements ISpellImmune {
    @ObjectHolder(value="psi:spell_circle")
    public static EntityType<EntitySpellCircle> TYPE;
    public static final int CAST_TIMES = 20;
    public static final int CAST_DELAY = 5;
    public static final int LIVE_TIME = 110;
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_CASTER = "caster";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_TIMES_CAST = "timesCast";
    private static final String TAG_LOOK_X = "savedLookX";
    private static final String TAG_LOOK_Y = "savedLookY";
    private static final String TAG_LOOK_Z = "savedLookZ";
    public static final EntityDataAccessor<ItemStack> COLORIZER_DATA;
    private static final EntityDataAccessor<ItemStack> BULLET_DATA;
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID;
    private static final EntityDataAccessor<Integer> TIME_ALIVE;
    private static final EntityDataAccessor<Integer> TIMES_CAST;
    private static final EntityDataAccessor<Float> LOOK_X;
    private static final EntityDataAccessor<Float> LOOK_Y;
    private static final EntityDataAccessor<Float> LOOK_Z;

    public EntitySpellCircle(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntitySpellCircle setInfo(Player player, ItemStack colorizer, ItemStack bullet) {
        this.f_19804_.m_135381_(COLORIZER_DATA, (Object)colorizer);
        this.f_19804_.m_135381_(BULLET_DATA, (Object)bullet.m_41777_());
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(player.m_142081_()));
        Vec3 lookVec = player.m_20252_(1.0f);
        this.f_19804_.m_135381_(LOOK_X, (Object)Float.valueOf((float)lookVec.f_82479_));
        this.f_19804_.m_135381_(LOOK_Y, (Object)Float.valueOf((float)lookVec.f_82480_));
        this.f_19804_.m_135381_(LOOK_Z, (Object)Float.valueOf((float)lookVec.f_82481_));
        return this;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLORIZER_DATA, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(BULLET_DATA, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(TIME_ALIVE, (Object)0);
        this.f_19804_.m_135372_(TIMES_CAST, (Object)0);
        this.f_19804_.m_135372_(LOOK_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOOK_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOOK_Z, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(@Nonnull CompoundTag tagCompound) {
        CompoundTag colorizerCmp = new CompoundTag();
        ItemStack colorizer = (ItemStack)this.f_19804_.m_135370_(COLORIZER_DATA);
        if (!colorizer.m_41619_()) {
            colorizerCmp = colorizer.m_41739_(colorizerCmp);
        }
        tagCompound.m_128365_(TAG_COLORIZER, (Tag)colorizerCmp);
        CompoundTag bulletCmp = new CompoundTag();
        ItemStack bullet = (ItemStack)this.f_19804_.m_135370_(BULLET_DATA);
        if (!bullet.m_41619_()) {
            bulletCmp = bullet.m_41739_(bulletCmp);
        }
        tagCompound.m_128365_(TAG_BULLET, (Tag)bulletCmp);
        ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).ifPresent(u -> tagCompound.m_128359_(TAG_CASTER, u.toString()));
        tagCompound.m_128405_(TAG_TIME_ALIVE, this.getTimeAlive());
        tagCompound.m_128405_(TAG_TIMES_CAST, ((Integer)this.f_19804_.m_135370_(TIMES_CAST)).intValue());
        tagCompound.m_128350_(TAG_LOOK_X, ((Float)this.f_19804_.m_135370_(LOOK_X)).floatValue());
        tagCompound.m_128350_(TAG_LOOK_Y, ((Float)this.f_19804_.m_135370_(LOOK_Y)).floatValue());
        tagCompound.m_128350_(TAG_LOOK_Z, ((Float)this.f_19804_.m_135370_(LOOK_Z)).floatValue());
    }

    public void m_7378_(@Nonnull CompoundTag tagCompound) {
        CompoundTag colorizerCmp = tagCompound.m_128469_(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.m_41712_((CompoundTag)colorizerCmp);
        this.f_19804_.m_135381_(COLORIZER_DATA, (Object)colorizer);
        CompoundTag bulletCmp = tagCompound.m_128469_(TAG_BULLET);
        ItemStack bullet = ItemStack.m_41712_((CompoundTag)bulletCmp);
        this.f_19804_.m_135381_(BULLET_DATA, (Object)bullet);
        if (tagCompound.m_128441_(TAG_CASTER)) {
            this.f_19804_.m_135381_(CASTER_UUID, Optional.of(UUID.fromString(tagCompound.m_128461_(TAG_CASTER))));
        }
        this.setTimeAlive(tagCompound.m_128451_(TAG_TIME_ALIVE));
        this.f_19804_.m_135381_(TIMES_CAST, (Object)tagCompound.m_128451_(TAG_TIMES_CAST));
        this.f_19804_.m_135381_(LOOK_X, (Object)Float.valueOf(tagCompound.m_128457_(TAG_LOOK_X)));
        this.f_19804_.m_135381_(LOOK_Y, (Object)Float.valueOf(tagCompound.m_128457_(TAG_LOOK_Y)));
        this.f_19804_.m_135381_(LOOK_Z, (Object)Float.valueOf(tagCompound.m_128457_(TAG_LOOK_Z)));
    }

    public void m_8119_() {
        super.m_8119_();
        int timeAlive = this.getTimeAlive();
        if (timeAlive > 110) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.setTimeAlive(timeAlive + 1);
        int times = (Integer)this.f_19804_.m_135370_(TIMES_CAST);
        if (timeAlive > 5 && timeAlive % 5 == 0 && times < 20) {
            ItemStack spellContainer;
            SpellContext context = null;
            LivingEntity thrower = this.getCaster();
            if (thrower instanceof Player && !(spellContainer = (ItemStack)this.f_19804_.m_135370_(BULLET_DATA)).m_41619_() && ISpellAcceptor.isContainer(spellContainer)) {
                this.f_19804_.m_135381_(TIMES_CAST, (Object)(times + 1));
                Spell spell = ISpellAcceptor.acceptor(spellContainer).getSpell();
                if (spell != null) {
                    context = new SpellContext().setPlayer((Player)thrower).setFocalPoint(this).setSpell(spell).setLoopcastIndex(times);
                }
            }
            if (context != null) {
                context.cspell.safeExecute(context);
            }
        }
        if (this.f_19853_.f_46443_) {
            ItemStack colorizer = (ItemStack)this.f_19804_.m_135370_(COLORIZER_DATA);
            int colorVal = Psi.proxy.getColorForColorizer(colorizer);
            float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
            float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
            float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                double x = this.m_20185_() + (Math.random() - 0.5) * (double)this.m_20205_();
                double y = this.m_20186_() - this.m_6049_();
                double z = this.m_20189_() + (Math.random() - 0.5) * (double)this.m_20205_();
                float grav = -0.15f - (float)Math.random() * 0.03f;
                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
            }
        }
    }

    public Vec3 m_20154_() {
        float x = ((Float)this.f_19804_.m_135370_(LOOK_X)).floatValue();
        float y = ((Float)this.f_19804_.m_135370_(LOOK_Y)).floatValue();
        float z = ((Float)this.f_19804_.m_135370_(LOOK_Z)).floatValue();
        return new Vec3((double)x, (double)y, (double)z);
    }

    public int getTimeAlive() {
        return (Integer)this.f_19804_.m_135370_(TIME_ALIVE);
    }

    public void setTimeAlive(int i) {
        this.f_19804_.m_135381_(TIME_ALIVE, (Object)i);
    }

    @Nullable
    public LivingEntity getCaster() {
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).map(arg_0 -> ((Level)this.m_20193_()).m_46003_(arg_0)).orElse(null);
    }

    @Override
    public boolean isImmune() {
        return true;
    }

    public boolean m_6090_() {
        return true;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        COLORIZER_DATA = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        BULLET_DATA = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        CASTER_UUID = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        TIME_ALIVE = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TIMES_CAST = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        LOOK_X = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        LOOK_Y = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        LOOK_Z = SynchedEntityData.m_135353_(EntitySpellCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

