/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemSpellDrive;

public class ItemSpellBullet
extends Item {
    public static final String TAG_SPELL = "spell";

    public ItemSpellBullet(Item.Properties properties) {
        super(properties.m_41487_(16));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SpellAcceptor(stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        if (ISpellAcceptor.hasSpell(stack)) {
            CompoundTag cmp = stack.m_41784_().m_128469_(TAG_SPELL);
            String name = cmp.m_128461_("spellName");
            if (name.isEmpty()) {
                return super.m_7626_(stack);
            }
            return new TextComponent(name);
        }
        return super.m_7626_(stack);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Rarity m_41460_(ItemStack stack) {
        return ISpellAcceptor.hasSpell(stack) ? Rarity.RARE : Rarity.COMMON;
    }

    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            tooltip.add((Component)new TranslatableComponent("psimisc.bullet_type", new Object[]{new TranslatableComponent("psi.bullet_type_" + this.getBulletType())}));
            tooltip.add((Component)new TranslatableComponent("psimisc.bullet_cost", new Object[]{(int)(ISpellAcceptor.acceptor(stack).getCostModifier() * 100.0)}));
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), PsiSoundHandler.compileError, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.m_6674_(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public String getBulletType() {
        return "basic";
    }

    public ArrayList<Entity> castSpell(ItemStack stack, SpellContext context) {
        context.cspell.safeExecute(context);
        return new ArrayList<Entity>();
    }

    public boolean loopcastSpell(ItemStack stack, SpellContext context) {
        this.castSpell(stack, context);
        return false;
    }

    public double getCostModifier(ItemStack stack) {
        return 1.0;
    }

    public boolean isCADOnlyContainer(ItemStack stack) {
        return false;
    }

    protected static class SpellAcceptor
    implements ICapabilityProvider,
    ISpellAcceptor {
        protected final ItemStack stack;
        private final LazyOptional<ISpellAcceptor> capOptional;

        protected SpellAcceptor(ItemStack stack) {
            this.stack = stack;
            this.capOptional = LazyOptional.of(() -> this);
        }

        private ItemSpellBullet bulletItem() {
            return (ItemSpellBullet)this.stack.m_41720_();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PsiAPI.SPELL_ACCEPTOR_CAPABILITY.orEmpty(cap, this.capOptional);
        }

        @Override
        public void setSpell(Player player, Spell spell) {
            if (this.stack.m_41613_() == 1) {
                ItemSpellDrive.setSpell(this.stack, spell);
                return;
            }
            this.stack.m_41774_(1);
            ItemStack newStack = this.stack.m_41777_();
            newStack.m_41764_(1);
            ItemSpellDrive.setSpell(newStack, spell);
            if (!player.m_36356_(newStack)) {
                player.m_36176_(newStack, false);
            }
        }

        @Override
        public Spell getSpell() {
            return ItemSpellDrive.getSpell(this.stack);
        }

        @Override
        public boolean containsSpell() {
            return this.stack.m_41784_().m_128471_("has_spell");
        }

        @Override
        public ArrayList<Entity> castSpell(SpellContext context) {
            return this.bulletItem().castSpell(this.stack, context);
        }

        @Override
        public boolean loopcastSpell(SpellContext context) {
            return this.bulletItem().loopcastSpell(this.stack, context);
        }

        @Override
        public double getCostModifier() {
            return this.bulletItem().getCostModifier(this.stack);
        }

        @Override
        public boolean castableFromSocket() {
            return true;
        }

        @Override
        public boolean isCADOnlyContainer() {
            return this.bulletItem().isCADOnlyContainer(this.stack);
        }

        @Override
        public boolean requiresSneakForSpellSet() {
            return false;
        }
    }
}

