/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class ToolSocketable
implements ICapabilityProvider,
ISocketable,
IPsiBarDisplay,
ISpellAcceptor {
    protected final ItemStack tool;
    protected final int slots;
    private final LazyOptional<?> capOptional;

    public ToolSocketable(ItemStack tool, int slots) {
        this.tool = tool;
        this.slots = Mth.m_14045_((int)slots, (int)1, (int)11);
        this.capOptional = LazyOptional.of(() -> this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PsiAPI.SOCKETABLE_CAPABILITY || cap == PsiAPI.PSI_BAR_DISPLAY_CAPABILITY || cap == PsiAPI.SPELL_ACCEPTOR_CAPABILITY) {
            return this.capOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.slots && slot >= 0;
    }

    @Override
    public List<Integer> getRadialMenuSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i <= this.slots; ++i) {
            list.add(i);
        }
        return list;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        String name = "bullet" + slot;
        CompoundTag cmp = this.tool.m_41784_().m_128469_(name);
        if (cmp.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        String name = "bullet" + slot;
        CompoundTag cmp = new CompoundTag();
        if (!bullet.m_41619_()) {
            cmp = bullet.m_41739_(cmp);
        }
        this.tool.m_41784_().m_128365_(name, (Tag)cmp);
    }

    @Override
    public int getSelectedSlot() {
        return this.tool.m_41784_().m_128451_("selectedSlot");
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.tool.m_41784_().m_128405_("selectedSlot", slot);
    }

    @Override
    public int getLastSlot() {
        return this.slots - 1;
    }

    @Override
    public boolean shouldShow(IPlayerData data) {
        return false;
    }

    @Override
    public void setSpell(Player player, Spell spell) {
        int slot = this.getSelectedSlot();
        ItemStack bullet = this.getBulletInSocket(slot);
        if (!bullet.m_41619_() && ISpellAcceptor.isAcceptor(bullet)) {
            ISpellAcceptor.acceptor(bullet).setSpell(player, spell);
            this.setBulletInSocket(slot, bullet);
        }
    }

    @Override
    public boolean castableFromSocket() {
        return false;
    }
}

