/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.common.spell.operator.vector.PieceOperatorVectorRaycast;

public class PieceOperatorFocusedEntity
extends PieceOperator {
    SpellParam<Entity> target;

    public PieceOperatorFocusedEntity(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity e = this.getParamValue(context, this.target);
        if (e == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        Entity looked = PieceOperatorFocusedEntity.getEntityLookedAt(e);
        if (looked == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return looked;
    }

    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        BlockHitResult pos = PieceOperatorVectorRaycast.raycast(e, 32.0);
        Vec3 positionVector = e.m_20182_();
        if (e instanceof Player) {
            positionVector = positionVector.m_82520_(0.0, (double)e.m_20192_(), 0.0);
        }
        if (pos != null) {
            distance = pos.m_82450_().m_82554_(positionVector);
        }
        Vec3 lookVector = e.m_20154_();
        Vec3 reachVector = positionVector.m_82520_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.m_20193_().m_45933_(e, e.m_142469_().m_82377_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0).m_82377_(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.m_6087_()) {
                double distanceToEntity;
                float collisionBorderSize = entity.m_6143_();
                AABB hitbox = entity.m_142469_().m_82377_((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                Optional interceptPosition = hitbox.m_82371_(positionVector, reachVector);
                if (hitbox.m_82390_(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.m_82554_((Vec3)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

