/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> maxBlocks;

    public PieceTrickMoveBlockSequence(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel("psi.spellparam.max", true).mul(10.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel("psi.spellparam.max", true).sub(1.0).parenthesize().mul(10.5).add(18.0).floor());
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam(this.direction);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException, ArithmeticException {
        super.addToMetadata(meta);
        double maxBlocksVal = SpellHelpers.ensurePositiveAndNonzero(this, this.maxBlocks);
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 10.0));
        meta.addStat(EnumSpellStat.COST, (int)(18.0 + (maxBlocksVal - 1.0) * 10.5));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockPos pushToPos;
        BlockState state;
        Vector3 directionVal = SpellHelpers.getVector3(this, context, this.direction, false, true);
        Vector3 positionVal = SpellHelpers.getVector3(this, context, this.position, true, false);
        Vector3 targetVal = SpellHelpers.getVector3(this, context, this.target, false, false);
        int maxBlocksVal = this.getParamValue(context, this.maxBlocks).intValue();
        Level world = context.caster.f_19853_;
        HashMap<BlockPos, BlockState> toSet = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> toRemove = new HashMap<BlockPos, BlockState>();
        Vector3 directNorm = directionVal.copy().normalize();
        Vector3 targetNorm = targetVal.copy().normalize();
        LinkedHashSet<BlockPos> positions = MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksVal)).toVec3D(), maxBlocksVal);
        LinkedHashSet<BlockPos> moveableBlocks = new LinkedHashSet<BlockPos>();
        LinkedHashSet<BlockPos> immovableBlocks = new LinkedHashSet<BlockPos>();
        if (context.positionBroken != null) {
            immovableBlocks.add(context.positionBroken.m_82425_());
        }
        for (BlockPos blockPos : positions) {
            boolean isOffWorld;
            state = world.m_8055_(blockPos);
            if (world.m_46859_(blockPos)) continue;
            if (!(world.m_7702_(blockPos) == null && state.m_60811_() == PushReaction.NORMAL && state.m_60800_((BlockGetter)world, blockPos) != -1.0f && PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, blockPos, context.getHarvestTool()) && SpellHelpers.isBlockPosInRadius(context, blockPos) && world.m_7966_(context.caster, blockPos))) {
                immovableBlocks.add(blockPos);
                continue;
            }
            pushToPos = blockPos.m_142022_(directNorm.x, directNorm.y, directNorm.z);
            boolean bl = isOffWorld = pushToPos.m_123342_() < 0 || pushToPos.m_123342_() > 256;
            if (isOffWorld) {
                immovableBlocks.add(blockPos);
                continue;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, blockPos, state, context.caster);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                immovableBlocks.add(blockPos);
                continue;
            }
            moveableBlocks.add(blockPos);
        }
        block1: for (BlockPos blockPos : moveableBlocks) {
            state = world.m_8055_(blockPos);
            pushToPos = blockPos.m_142022_(directNorm.x, directNorm.y, directNorm.z);
            BlockState pushToState = world.m_8055_(pushToPos);
            if (immovableBlocks.contains(pushToPos) || immovableBlocks.contains(blockPos)) continue;
            if (moveableBlocks.contains(pushToPos)) {
                BlockPos nextPos = pushToPos;
                while (moveableBlocks.contains(nextPos)) {
                    BlockPos nextPosPushPos = nextPos.m_142022_(directNorm.x, directNorm.y, directNorm.z);
                    BlockState nextPosPushPosState = world.m_8055_(nextPosPushPos);
                    if (moveableBlocks.contains(nextPosPushPos)) {
                        nextPos = nextPosPushPos;
                        continue;
                    }
                    if (immovableBlocks.contains(nextPosPushPos) || !world.m_46859_(nextPosPushPos) && !nextPosPushPosState.m_60767_().m_76336_()) {
                        continue block1;
                    }
                    break;
                }
            } else if (!world.m_46859_(pushToPos) && !pushToState.m_60767_().m_76336_()) continue;
            toRemove.put(blockPos, state);
            toSet.put(pushToPos, state);
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            context.caster.f_19853_.m_7471_((BlockPos)entry.getKey(), true);
            context.caster.f_19853_.m_46796_(2001, (BlockPos)entry.getKey(), Block.m_49956_((BlockState)((BlockState)entry.getValue())));
        }
        for (Map.Entry entry : toSet.entrySet()) {
            context.caster.f_19853_.m_46597_((BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        return null;
    }
}

