/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.ModResourcesFinder;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.client.BlockColorHandler;
import dev.gigaherz.jsonthings.things.client.ItemColorHandler;
import dev.gigaherz.jsonthings.things.parsers.ArmorMaterialParser;
import dev.gigaherz.jsonthings.things.parsers.BlockMaterialParser;
import dev.gigaherz.jsonthings.things.parsers.BlockParser;
import dev.gigaherz.jsonthings.things.parsers.CreativeModeTabParser;
import dev.gigaherz.jsonthings.things.parsers.EnchantmentParser;
import dev.gigaherz.jsonthings.things.parsers.FluidParser;
import dev.gigaherz.jsonthings.things.parsers.FoodParser;
import dev.gigaherz.jsonthings.things.parsers.ItemParser;
import dev.gigaherz.jsonthings.things.parsers.MobEffectInstanceParser;
import dev.gigaherz.jsonthings.things.parsers.ShapeParser;
import dev.gigaherz.jsonthings.things.parsers.ThingResourceManager;
import dev.gigaherz.jsonthings.things.parsers.TierParser;
import dev.gigaherz.jsonthings.things.scripting.ScriptParser;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.resource.ResourcePackLoader;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="jsonthings", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="jsonthings")
public class JsonThings {
    public static final String MODID = "jsonthings";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static BlockParser blockParser;
    public static ItemParser itemParser;
    public static FluidParser fluidParser;
    public static EnchantmentParser enchantmentParser;
    public static FoodParser foodParser;
    public static ShapeParser shapeParser;
    public static TierParser tierParser;
    public static BlockMaterialParser blockMaterialParser;
    public static ArmorMaterialParser armorMaterialParser;
    public static CreativeModeTabParser creativeModeTabParser;
    public static MobEffectInstanceParser mobEffectInstanceParser;
    private static CompletableFuture<ThingResourceManager> loaderFuture;

    public JsonThings() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ThingResourceManager manager = ThingResourceManager.instance();
        if (ModList.get().isLoaded("rhino")) {
            ScriptParser.enable(manager);
        }
        blockParser = manager.registerParser(new BlockParser(bus));
        itemParser = manager.registerParser(new ItemParser(bus));
        fluidParser = manager.registerParser(new FluidParser(bus));
        enchantmentParser = manager.registerParser(new EnchantmentParser(bus));
        foodParser = manager.registerParser(new FoodParser());
        shapeParser = manager.registerParser(new ShapeParser());
        tierParser = manager.registerParser(new TierParser());
        blockMaterialParser = manager.registerParser(new BlockMaterialParser());
        armorMaterialParser = manager.registerParser(new ArmorMaterialParser());
        creativeModeTabParser = manager.registerParser(new CreativeModeTabParser());
        mobEffectInstanceParser = manager.registerParser(new MobEffectInstanceParser());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> {
            try {
                ThingResourceManager instance = ThingResourceManager.instance();
                ResourcePackLoader.loadResourcePacks((PackRepository)instance.getRepository(), ModResourcesFinder::buildPackFinder);
                loaderFuture = instance.beginLoading();
            }
            catch (Exception e) {
                LOGGER.error("Exception during FMLConstructModEvent", (Throwable)e);
            }
        });
    }

    @SubscribeEvent
    public static void packFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(ThingResourceManager.instance().getWrappedPackFinder());
        }
    }

    @SubscribeEvent
    public static void finishLoading(NewRegistryEvent event) {
        ThingResourceManager.instance().waitForLoading(loaderFuture);
        loaderFuture = null;
    }

    static {
        ThingRegistries.staticInit();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="jsonthings", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientHandlers {
        public static void addClientPackFinder() {
            Minecraft.m_91087_().m_91099_().addPackFinder(ThingResourceManager.instance().getWrappedPackFinder());
        }

        @SubscribeEvent
        public static void constructMod(FMLConstructModEvent event) {
            event.enqueueWork(() -> {
                ClientHandlers.addClientPackFinder();
                BlockColorHandler.init();
                ItemColorHandler.init();
            });
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> {
                ThingResourceManager thingPackManager = ThingResourceManager.instance();
                return new PackSelectionScreen(screen, thingPackManager.getRepository(), rpl -> thingPackManager.onConfigScreenSave(), thingPackManager.getThingPacksLocation(), (Component)new TextComponent("Thing Packs"));
            }));
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            blockParser.getBuilders().forEach(thing -> {
                block5: {
                    Set<String> layers;
                    block4: {
                        if (thing.isInErrorState()) {
                            return;
                        }
                        layers = thing.getRenderLayers();
                        if (layers.size() != 1) break block4;
                        if (layers.contains("solid")) break block5;
                    }
                    Set renderTypes = layers.stream().map(arg_0 -> ((ImmutableBiMap)MultiLayerModel.Loader.BLOCK_LAYERS).get(arg_0)).collect(Collectors.toSet());
                    ItemBlockRenderTypes.setRenderLayer((Block)((IFlexBlock)thing.get()).self(), renderTypes::contains);
                }
            });
            fluidParser.getBuilders().forEach(thing -> {
                block6: {
                    Set<String> layers;
                    block5: {
                        if (thing.isInErrorState()) {
                            return;
                        }
                        layers = thing.getRenderLayers();
                        if (layers.size() != 1) break block5;
                        if (layers.contains("solid")) break block6;
                    }
                    Set renderTypes = layers.stream().map(arg_0 -> ((ImmutableBiMap)MultiLayerModel.Loader.BLOCK_LAYERS).get(arg_0)).collect(Collectors.toSet());
                    for (Fluid fluid : thing.getAllSiblings()) {
                        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, renderTypes::contains);
                    }
                }
            });
        }

        @SubscribeEvent
        public static void itemColorHandlers(ColorHandlerEvent.Block event) {
            blockParser.getBuilders().forEach(thing -> {
                String handlerName = thing.getColorHandler();
                if (handlerName != null) {
                    BlockColor bc = BlockColorHandler.get(handlerName);
                    event.getBlockColors().m_92589_(bc, new Block[]{((IFlexBlock)thing.get()).self()});
                }
            });
        }

        @SubscribeEvent
        public static void itemColorHandlers(ColorHandlerEvent.Item event) {
            itemParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                String handlerName = thing.getColorHandler();
                if (handlerName != null) {
                    Function<BlockColors, ItemColor> handler = ItemColorHandler.get(handlerName);
                    ItemColor ic = handler.apply(event.getBlockColors());
                    event.getItemColors().m_92689_(ic, new ItemLike[]{((IFlexItem)thing.get()).self()});
                }
            });
        }
    }
}

