/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathResourcePack;
import org.slf4j.Logger;

class ModResourcesFinder {
    public static final Logger LOGGER = LogUtils.getLogger();

    ModResourcesFinder() {
    }

    static RepositorySource buildPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks) {
        return (packList, factory) -> ModResourcesFinder.serverPackFinder(modResourcePacks, packList, factory);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks, Consumer<Pack> consumer, Pack.PackConstructor factory) {
        for (Map.Entry<IModFile, ? extends PathResourcePack> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            Pack packInfo = Pack.m_10430_((String)name, (boolean)false, e::getValue, (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (packInfo == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug("Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            consumer.accept(packInfo);
        }
    }
}

