/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.blocks;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventResult;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlexTrapdoorBlock
extends TrapDoorBlock
implements IFlexBlock {
    private DynamicShape generalShape;
    private DynamicShape collisionShape;
    private DynamicShape raytraceShape;
    private DynamicShape renderShape;
    private final Map<String, FlexEventHandler> eventHandlers = Maps.newHashMap();

    public FlexTrapdoorBlock(BlockBehaviour.Properties properties, Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        super(properties);
        this.initializeFlex(propertyDefaultValues);
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (propertyDefaultValues.size() > 0) {
            BlockState def = (BlockState)this.m_49965_().m_61090_();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (BlockState)def.m_61124_(prop, value);
            }
            this.m_49959_(def);
        }
    }

    @Override
    public void addEventHandler(String eventName, FlexEventHandler eventHandler) {
        this.eventHandlers.put(eventName, eventHandler);
    }

    @Override
    public FlexEventHandler getEventHandler(String eventName) {
        return this.eventHandlers.get(eventName);
    }

    @Override
    public void setGeneralShape(@Nullable DynamicShape shape) {
        this.generalShape = shape;
    }

    @Override
    public void setCollisionShape(@Nullable DynamicShape shape) {
        this.collisionShape = shape;
    }

    @Override
    public void setRaytraceShape(@Nullable DynamicShape shape) {
        this.raytraceShape = shape;
    }

    @Override
    public void setRenderShape(@Nullable DynamicShape shape) {
        this.renderShape = shape;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (this.generalShape != null) {
            return this.generalShape.getShape(state);
        }
        return super.m_5940_(state, worldIn, pos, context);
    }

    @Deprecated
    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.raytraceShape != null) {
            return this.raytraceShape.getShape(state);
        }
        return super.m_6079_(state, worldIn, pos);
    }

    @Deprecated
    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        if (this.collisionShape != null) {
            return this.collisionShape.getShape(state);
        }
        return super.m_7947_(state, reader, pos);
    }

    @Deprecated
    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.renderShape != null) {
            return this.renderShape.getShape(state);
        }
        return super.m_7952_(state, worldIn, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.runEvent("use", FlexEventContext.of(worldIn, pos, state).withHand(player, handIn).withRayTrace(hit), () -> FlexEventResult.of(super.m_6227_(state, worldIn, pos, player, handIn, hit))).result();
    }
}

