/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexFluidType;
import dev.gigaherz.jsonthings.things.serializers.IFluidFactory;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class FluidBuilder
extends BaseBuilder<IFlexFluid, FluidBuilder> {
    private FlexFluidType<?> fluidType;
    private List<Property<?>> properties;
    private Map<String, Property<?>> propertiesByName;
    private Map<String, String> propertyDefaultValues;
    private Map<Property<?>, Comparable<?>> propertyDefaultValuesMap;
    private ItemBuilder itemBuilder;
    private ResourceLocation parentBuilderName;
    private FluidBuilder parentBuilder;
    private RegistryObject<Fluid> parentFluid;
    private ResourceLocation stillTexture;
    private ResourceLocation flowingTexture;
    private ResourceLocation sideTexture;
    private Rarity rarity = Rarity.COMMON;
    private Integer color;
    private Integer density;
    private Integer luminosity;
    private Integer temperature;
    private Integer viscosity;
    private String translationKey;
    private Boolean isGaseous;
    private ResourceLocation fillSound;
    private ResourceLocation emptySound;
    private Set<String> renderLayers;
    private IFluidFactory<? extends Fluid> factory;

    public static FluidBuilder begin(ThingParser<FluidBuilder> ownerParser, ResourceLocation registryName) {
        return new FluidBuilder(ownerParser, registryName);
    }

    private FluidBuilder(ThingParser<FluidBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Fluid";
    }

    public void setFluidType(ResourceLocation typeName) {
        FlexFluidType FluidType = (FlexFluidType)ThingRegistries.FLUID_TYPES.m_7745_(typeName);
        if (FluidType == null) {
            throw new IllegalStateException("No known Fluid type with name " + typeName);
        }
        this.fluidType = FluidType;
    }

    public void setBucket(ItemBuilder itemBuilder) {
        this.itemBuilder = itemBuilder;
    }

    public void setParentFluid(ResourceLocation parentName) {
        if (this.parentFluid != null) {
            throw new IllegalStateException("Parent Fluid already set");
        }
        this.parentBuilderName = parentName;
        this.parentFluid = RegistryObject.create((ResourceLocation)parentName, (IForgeRegistry)ForgeRegistries.FLUIDS);
    }

    public void setProperties(Map<String, Property<?>> properties) {
        this.properties = properties.values().stream().toList();
        this.propertiesByName = properties;
    }

    public void setPropertyDefaultValue(String name, String value) {
        if (this.propertyDefaultValues == null) {
            this.propertyDefaultValues = new HashMap<String, String>();
        }
        this.propertyDefaultValues.put(name, value);
    }

    public void setStillTexture(ResourceLocation stillTexture) {
        this.stillTexture = stillTexture;
    }

    public void setFlowingTexture(ResourceLocation flowingTexture) {
        this.flowingTexture = flowingTexture;
    }

    public void setSideTexture(ResourceLocation overlay) {
        this.sideTexture = overlay;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public void setDensity(Integer density) {
        this.density = density;
    }

    public void setLuminosity(Integer luminosity) {
        this.luminosity = luminosity;
    }

    public void setTemperature(Integer temperature) {
        this.temperature = temperature;
    }

    public void setViscosity(Integer viscosity) {
        this.viscosity = viscosity;
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public void setGaseous(Boolean gaseous) {
        this.isGaseous = gaseous;
    }

    public void setFillSound(ResourceLocation fillSound) {
        this.fillSound = fillSound;
    }

    public void setEmptySound(ResourceLocation emptySound) {
        this.emptySound = emptySound;
    }

    public void setRenderLayers(Set<String> renderLayers) {
        this.renderLayers = renderLayers;
    }

    @Override
    protected IFlexFluid buildInternal() {
        FlexFluidType<?> fluidType = this.getFluidType();
        List<Property<?>> stockProperties = fluidType.getStockProperties();
        List<Property<?>> properties = this.getProperties();
        List<Property> badProperties = properties.stream().filter(prop -> {
            for (Property p : stockProperties) {
                if (p == prop || !p.m_61708_().equals(prop.m_61708_())) continue;
                return true;
            }
            return false;
        }).toList();
        if (badProperties.size() > 0) {
            throw new IllegalStateException("The fluid of type " + fluidType + " cannot define non-duplicate properties with clashing names: " + badProperties.stream().map(Property::m_61708_).collect(Collectors.joining(" ")));
        }
        IFlexFluid flexFluid = (IFlexFluid)this.factory.construct(this);
        NonNullLazy attrsBuilder = NonNullLazy.of(() -> {
            SoundEvent emptySound;
            FluidAttributes.Builder attrs = FluidAttributes.builder((ResourceLocation)this.getStillTexture(), (ResourceLocation)this.getFlowingTexture());
            if (this.getColor() != null) {
                attrs.color(this.getColor().intValue());
            }
            if (this.getDensity() != null) {
                attrs.density(this.getDensity().intValue());
            }
            if (this.getLuminosity() != null) {
                attrs.luminosity(this.getLuminosity().intValue());
            }
            if (this.getSideTexture() != null) {
                attrs.overlay(this.getSideTexture());
            }
            if (this.getRarity() != null) {
                attrs.rarity(this.getRarity());
            }
            SoundEvent fillSound = this.getFillSound() != null ? (SoundEvent)Utils.getOrCrash(ForgeRegistries.SOUND_EVENTS, this.getFillSound()) : null;
            SoundEvent soundEvent = emptySound = this.getEmptySound() != null ? (SoundEvent)Utils.getOrCrash(ForgeRegistries.SOUND_EVENTS, this.getEmptySound()) : null;
            if (this.getFillSound() != null && this.getEmptySound() != null) {
                attrs.sound(fillSound, emptySound);
            }
            if (this.getTemperature() != null) {
                attrs.temperature(this.getTemperature().intValue());
            }
            if (this.getViscosity() != null) {
                attrs.viscosity(this.getViscosity().intValue());
            }
            if (this.getTranslationKey() != null) {
                attrs.translationKey(this.getTranslationKey());
            }
            if (this.getIsGaseous() != null && this.getIsGaseous().booleanValue()) {
                attrs.gaseous();
            }
            return attrs.build(flexFluid.self());
        });
        if (this.getBucketBuilder() != null) {
            flexFluid.setBucketItem((Supplier<Item>)Lazy.of(() -> ((IFlexItem)this.getBucketBuilder().get()).self()));
        }
        flexFluid.setAttributesBuilder((NonNullLazy<FluidAttributes>)attrsBuilder);
        this.constructEventHandlers(flexFluid);
        return flexFluid;
    }

    public FluidBuilder getParentBuilderName() {
        if (this.parentBuilder == null) {
            if (this.parentBuilderName == null) {
                throw new IllegalStateException("Parent not set");
            }
            this.parentBuilder = (FluidBuilder)JsonThings.fluidParser.getBuildersMap().get(this.parentBuilderName);
            if (this.parentBuilder == null) {
                throw new IllegalStateException("The specified parent " + this.parentBuilderName + " is not a Json Things defined Fluid");
            }
        }
        return this.parentBuilder;
    }

    @Override
    @Nullable
    public FluidBuilder getParent() {
        if (this.parentBuilderName == null) {
            return null;
        }
        if (this.parentBuilder == null) {
            this.parentBuilder = (FluidBuilder)JsonThings.fluidParser.getBuildersMap().get(this.parentFluid.getId());
            if (this.parentBuilder == null) {
                this.parentBuilderName = null;
                return null;
            }
        }
        return this.parentBuilder;
    }

    @Nullable
    public FlexFluidType<?> getFluidTypeRaw() {
        return this.getValue(this.fluidType, FluidBuilder::getFluidTypeRaw);
    }

    public FlexFluidType<?> getFluidType() {
        return Utils.orElseGet(this.getFluidTypeRaw(), () -> FlexFluidType.PLAIN);
    }

    @Nullable
    public List<Property<?>> getPropertiesRaw() {
        return this.getValue(this.properties, FluidBuilder::getPropertiesRaw);
    }

    public List<Property<?>> getProperties() {
        return Utils.orElseGet(this.getPropertiesRaw(), List::of);
    }

    @Nullable
    public Map<String, String> getPropertyDefaultValuesRaw() {
        return this.getValue(this.propertyDefaultValues, FluidBuilder::getPropertyDefaultValuesRaw);
    }

    public Map<Property<?>, Comparable<?>> getPropertyDefaultValues() {
        if (this.propertyDefaultValuesMap == null) {
            Map<String, String> raw = this.getPropertyDefaultValuesRaw();
            this.propertyDefaultValuesMap = raw == null ? Map.of() : raw.entrySet().stream().map(e -> {
                Property<?> key = this.propertiesByName.get(e.getKey());
                Object value = Utils.getPropertyValue(key, (String)e.getValue());
                return Pair.of(key, value);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }
        return this.propertyDefaultValuesMap;
    }

    @Nullable
    public FluidBuilder getParentBuilder() {
        return this.parentBuilder;
    }

    public Map<String, Property<?>> getPropertiesByName() {
        return Collections.unmodifiableMap(this.propertiesByName);
    }

    @Nullable
    public ItemBuilder getBucketBuilder() {
        return this.itemBuilder;
    }

    @Nullable
    public RegistryObject<Fluid> getParentFluid() {
        return this.parentFluid;
    }

    @Nullable
    private ResourceLocation getStillTexture() {
        return this.getValue(this.stillTexture, FluidBuilder::getStillTexture);
    }

    @Nullable
    private ResourceLocation getFlowingTexture() {
        return this.getValue(this.flowingTexture, FluidBuilder::getFlowingTexture);
    }

    @Nullable
    private Rarity getRarity() {
        return this.getValue(this.rarity, FluidBuilder::getRarity);
    }

    @Nullable
    private ResourceLocation getSideTexture() {
        return this.getValue(this.sideTexture, FluidBuilder::getSideTexture);
    }

    @Nullable
    private Integer getColor() {
        return this.getValue(this.color, FluidBuilder::getColor);
    }

    @Nullable
    private Integer getDensity() {
        return this.getValue(this.density, FluidBuilder::getDensity);
    }

    @Nullable
    private Integer getLuminosity() {
        return this.getValue(this.luminosity, FluidBuilder::getLuminosity);
    }

    @Nullable
    private Integer getTemperature() {
        return this.getValue(this.temperature, FluidBuilder::getTemperature);
    }

    @Nullable
    private Integer getViscosity() {
        return this.getValue(this.viscosity, FluidBuilder::getViscosity);
    }

    @Nullable
    private String getTranslationKey() {
        return this.getValue(this.translationKey, FluidBuilder::getTranslationKey);
    }

    @Nullable
    private Boolean getIsGaseous() {
        return this.getValue(this.isGaseous, FluidBuilder::getIsGaseous);
    }

    @Nullable
    private ResourceLocation getFillSound() {
        return this.getValue(this.fillSound, FluidBuilder::getFillSound);
    }

    @Nullable
    private ResourceLocation getEmptySound() {
        return this.getValue(this.emptySound, FluidBuilder::getEmptySound);
    }

    @Nullable
    public Set<String> getRenderLayersRaw() {
        return this.getValue(this.renderLayers, FluidBuilder::getRenderLayersRaw);
    }

    public Set<String> getRenderLayers() {
        return Utils.orElseGet(this.getRenderLayersRaw(), () -> Collections.singleton(this.getFluidType().getDefaultLayer()));
    }

    public ResourceLocation getDefaultRenderLayer() {
        return new ResourceLocation(this.getFluidType().getDefaultLayer());
    }

    public void register(IForgeRegistry<Fluid> registry) {
        if (this.isInErrorState()) {
            return;
        }
        this.get();
        this.factory.register(this, (name, obj) -> registry.register((IForgeRegistryEntry)((Fluid)obj.setRegistryName(name))));
    }

    public void setFactory(IFluidFactory<?> factory) {
        this.factory = factory;
    }

    public Iterable<Fluid> getAllSiblings() {
        return this.factory.getAllSiblings(this);
    }
}

