/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventResult;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;

public class FlexDiggerItem
extends DiggerItem
implements IFlexItem {
    private final Multimap<CreativeModeTab, StackContext> perTabStacks = ArrayListMultimap.create();
    private final List<StackContext> searchTabStacks = Lists.newArrayList();
    private final Map<String, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private final Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributeModifiers;
    private final UseAnim useAction;
    private final Integer useTime;
    private final UseFinishMode useFinishMode;
    private final List<MutableComponent> lore;
    private final Set<ToolAction> toolActions;
    private final int burnTime;

    public FlexDiggerItem(Tier material, float damage, float speed, TagKey<Block> breakable, Item.Properties properties, ItemBuilder builder) {
        super(damage, speed, material, breakable, properties);
        this.useAction = builder.getUseAnim();
        this.useTime = builder.getUseTime();
        this.useFinishMode = builder.getUseFinishMode();
        this.attributeModifiers = builder.getAttributeModifiers();
        this.lore = builder.getLore();
        this.toolActions = builder.getToolActions();
        this.burnTime = Utils.orElse(builder.getBurnDuration(), -1);
        this.initializeFlex();
    }

    private void initializeFlex() {
        for (EquipmentSlot slot1 : EquipmentSlot.values()) {
            this.attributeModifiers.computeIfAbsent(slot1, key -> ArrayListMultimap.create()).putAll(super.getAttributeModifiers(slot1, ItemStack.f_41583_));
        }
    }

    @Override
    public void addEventHandler(String eventName, FlexEventHandler eventHandler) {
        this.eventHandlers.put(eventName, eventHandler);
    }

    @Override
    public FlexEventHandler getEventHandler(String eventName) {
        return this.eventHandlers.get(eventName);
    }

    @Override
    public void addCreativeStack(StackContext stack, Iterable<CreativeModeTab> tabs) {
        for (CreativeModeTab tab : tabs) {
            this.perTabStacks.put((Object)tab, (Object)stack);
        }
        this.searchTabStacks.add(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (this.useTime != null && this.useTime > 0) {
            return this.runEvent("begin_using", FlexEventContext.of(worldIn, (LivingEntity)playerIn, handIn, heldItem), () -> {
                playerIn.m_6672_(handIn);
                return FlexEventResult.consume(heldItem);
            }).holder();
        }
        return this.runEvent("use_on_air", FlexEventContext.of(worldIn, (LivingEntity)playerIn, handIn, heldItem), () -> FlexEventResult.of(super.m_7203_(worldIn, playerIn, handIn))).holder();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack heldItem = context.m_43722_();
        FlexEventResult result = this.runEvent("use_on_block", FlexEventContext.of(context), () -> new FlexEventResult(super.m_6225_(context), heldItem));
        if (result.stack() != heldItem && context.m_43723_() != null) {
            context.m_43723_().m_21008_(context.m_43724_(), result.stack());
        }
        return result.result();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return Utils.orElseGet(this.useAction, () -> super.m_6164_(stack));
    }

    public int m_8105_(ItemStack stack) {
        return Utils.orElseGet(this.useTime, () -> super.m_8105_(stack));
    }

    public boolean m_41463_(ItemStack stack) {
        if (this.useFinishMode != null) {
            return this.useFinishMode.isUseOnRelease();
        }
        return super.m_41463_(stack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        this.runEvent("stopped_using", FlexEventContext.of(worldIn, entityLiving, stack).with(FlexEventContext.TIME_LEFT, timeLeft), () -> {
            super.m_5551_(stack, worldIn, entityLiving, timeLeft);
            return FlexEventResult.pass(stack);
        });
    }

    public ItemStack m_5922_(ItemStack heldItem, Level worldIn, LivingEntity entityLiving) {
        Supplier<FlexEventResult> resultSupplier = () -> FlexEventResult.success(super.m_5922_(heldItem, worldIn, entityLiving));
        FlexEventResult result = this.runEvent("end_using", FlexEventContext.of(worldIn, entityLiving, heldItem), resultSupplier);
        if (result.result() != InteractionResult.SUCCESS) {
            return result.stack();
        }
        return this.runEvent("use", FlexEventContext.of(worldIn, entityLiving, heldItem), () -> FlexEventResult.success(result.stack())).stack();
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.lore != null) {
            tooltip.addAll(this.lore);
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (tab == CreativeModeTab.f_40754_) {
            this.searchTabStacks.stream().map(s -> s.toStack((Item)this)).forEach(arg_0 -> items.add(arg_0));
        } else if (this.perTabStacks.containsKey((Object)tab)) {
            this.perTabStacks.get((Object)tab).stream().map(s -> s.toStack((Item)this)).forEach(arg_0 -> items.add(arg_0));
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        FlexEventResult result = this.runEvent("update", FlexEventContext.of(worldIn, entityIn, stack).with(FlexEventContext.SLOT, itemSlot).with(FlexEventContext.SELECTED, isSelected), () -> {
            super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
            return FlexEventResult.pass(stack);
        });
        if (result.stack() != stack) {
            entityIn.m_141942_(itemSlot).m_142104_(result.stack());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return Utils.orElseGet(this.attributeModifiers.get(slot), HashMultimap::create);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (this.toolActions != null) {
            return this.toolActions.contains(toolAction);
        }
        return super.canPerformAction(stack, toolAction);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }
}

