/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.ArmorMaterialBuilder;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexArmorMaterial;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.parsers.TierParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class ArmorMaterialParser
extends ThingParser<ArmorMaterialBuilder> {
    public ArmorMaterialParser() {
        super(GSON, "armor_material");
    }

    @Override
    protected void finishLoadingInternal() {
        ArmorMaterialParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.m_122965_(ThingRegistries.ARMOR_MATERIALS, (ResourceLocation)thing.getRegistryName(), (Object)((FlexArmorMaterial)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public ArmorMaterialBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ArmorMaterialBuilder> builderModification) {
        ArmorMaterialBuilder builder = ArmorMaterialBuilder.begin(this, key);
        JParse.begin(data).key("toughness", val -> val.floatValue().min(0.0f).handle(builder::setToughness)).key("knockback_resistance", val -> val.floatValue().min(0.0f).handle(builder::setKnockbackResistance)).key("enchantment_value", val -> val.intValue().min(0).handle(builder::setEnchantmentValue)).key("repair_ingredient", val -> val.map(TierParser::parseMiniIngredient).handle(builder::setRepairIngredient)).key("equip_sound", val -> val.string().map(ResourceLocation::new).handle(builder::setEquipSound)).key("durability", val -> val.map(this::parseEquipmentSlotMap).handle(builder::setDurability)).key("armor", val -> val.map(this::parseEquipmentSlotMap).handle(builder::setDefense));
        builderModification.accept(builder);
        return builder;
    }

    private Map<EquipmentSlot, Integer> parseEquipmentSlotMap(Any data) {
        HashMap<EquipmentSlot, Integer> map = new HashMap<EquipmentSlot, Integer>();
        data.ifObj(obj -> {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                obj.ifKey(slot.m_20751_(), val -> val.intValue().handle(num -> map.put(slot, num)));
            }
        }).ifInteger(val -> {
            int num = val.getAsInt();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                map.put(slot, num);
            }
        }).typeError();
        return map;
    }
}

