/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FluidBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.properties.PropertyType;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidParser
extends ThingParser<FluidBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public FluidParser(IEventBus bus) {
        super(GSON, "fluid");
        bus.addGenericListener(Fluid.class, this::registerFluids);
    }

    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        LOGGER.info("Started registering Fluid things, errors about unexpected registry domains are harmless...");
        IForgeRegistry registry = event.getRegistry();
        FluidParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> thing.register((IForgeRegistry<Fluid>)registry), BaseBuilder::getRegistryName);
        LOGGER.info("Done processing thingpack Blocks.");
    }

    @Override
    public FluidBuilder processThing(ResourceLocation key, JsonObject data, Consumer<FluidBuilder> builderModification) {
        FluidBuilder builder = FluidBuilder.begin(this, key);
        MutableObject propertiesByName = new MutableObject(new HashMap());
        JParse.begin(data).ifKey("parent", val -> val.string().map(ResourceLocation::new).handle(builder::setParent)).ifKey("type", val -> val.string().map(ResourceLocation::new).handle(builder::setFluidType)).ifKey("properties", val -> val.obj().map(this::parseProperties).handle(properties -> {
            propertiesByName.setValue(properties);
            builder.setProperties((Map<String, Property<?>>)properties);
        })).ifKey("default_state", val -> val.obj().raw(obj -> this.parseFluidState((JsonObject)obj, builder))).ifKey("bucket", val -> {
            ResourceLocation thisName = builder.getRegistryName();
            ResourceLocation bucketName = new ResourceLocation(thisName.m_135827_(), thisName.m_135815_() + "_bucket");
            val.ifBool(v -> v.handle(b -> {
                if (b) {
                    this.createStockBucketItem(bucketName, builder, new JsonObject());
                }
            })).ifObj(obj -> obj.raw(item -> this.createStockBucketItem(bucketName, builder, (JsonObject)item)));
        }).ifKey("translation_key", val -> val.string().handle(builder::setTranslationKey)).key("still_texture", val -> val.string().map(ResourceLocation::new).handle(builder::setStillTexture)).key("flowing_texture", val -> val.string().map(ResourceLocation::new).handle(builder::setFlowingTexture)).ifKey("side_texture", val -> val.string().map(ResourceLocation::new).handle(builder::setSideTexture)).ifKey("rarity", val -> val.string().map(ThingParser::parseRarity).handle(builder::setRarity)).ifKey("color", val -> val.ifObj(obj -> obj.map(ThingParser::parseColor).handle(builder::setColor)).ifArray(arr -> arr.mapWhole(ThingParser::parseColor).handle(builder::setColor)).ifString(str -> str.map(ThingParser::parseColor).handle(builder::setColor)).ifInteger(i -> i.handle(builder::setColor)).typeError()).ifKey("density", val -> val.intValue().handle(builder::setDensity)).ifKey("luminosity", val -> val.intValue().handle(builder::setLuminosity)).ifKey("temperature", val -> val.intValue().handle(builder::setTemperature)).ifKey("viscosity", val -> val.intValue().handle(builder::setViscosity)).ifKey("gaseous", val -> val.bool().handle(builder::setGaseous)).ifKey("render_layer", val -> val.map(ThingParser::parseRenderLayers).handle(builder::setRenderLayers)).ifKey("fill_sound", val -> val.string().map(ResourceLocation::new).handle(builder::setFillSound)).ifKey("empty_sound", val -> val.string().map(ResourceLocation::new).handle(builder::setEmptySound)).ifKey("events", val -> val.obj().map(this::parseEvents).handle(builder::setEventMap));
        builderModification.accept(builder);
        builder.setFactory(builder.getFluidType().getFactory(key, data));
        return builder;
    }

    private void parseFluidState(JsonObject props, FluidBuilder builder) {
        for (Map.Entry entry : props.entrySet()) {
            String name = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            builder.setPropertyDefaultValue(name, value.getAsString());
        }
    }

    private Map<String, Property<?>> parseProperties(ObjValue props) {
        HashMap map = new HashMap();
        props.forEach((name, val) -> val.ifString(str -> str.handle(prop -> {
            Property property = (Property)ThingRegistries.PROPERTIES.m_7745_(new ResourceLocation(prop));
            if (property == null) {
                throw new ThingParseException("Property with name " + prop + " not found in ThingRegistries.PROPERTIES");
            }
            if (!property.m_61708_().equals(name)) {
                throw new ThingParseException("The stock property '" + prop + "' does not have the expected name '" + name + "' != '" + property.m_61708_() + "'");
            }
            map.put((String)name, (Property<?>)property);
        })).ifObj(obj -> obj.raw(rawObj -> map.put((String)name, PropertyType.deserialize(name, rawObj)))).typeError());
        return map;
    }

    private void createStockBucketItem(ResourceLocation bucketName, FluidBuilder builder, JsonObject jsonObject) {
        try {
            if (jsonObject.has("fluid")) {
                throw new ThingParseException("Inline fluid bucket definition cannot contain a fluid entry.");
            }
            jsonObject.addProperty("fluid", builder.getRegistryName().toString());
            ItemBuilder bucketBuilder = JsonThings.itemParser.parseFromElement(bucketName, (JsonElement)jsonObject, b -> b.setType(FlexItemType.BUCKET));
            if (bucketBuilder != null) {
                builder.setBucket(bucketBuilder);
            }
        }
        catch (Exception e) {
            throw new ThingParseException("Exception while parsing nested bucket in " + builder.getRegistryName(), e);
        }
    }
}

