/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting;

import dev.gigaherz.jsonthings.things.parsers.ThingResourceManager;
import dev.gigaherz.jsonthings.things.scripting.ThingScript;
import dev.gigaherz.jsonthings.things.scripting.rhino.RhinoThingScript;
import dev.gigaherz.jsonthings.util.KeyNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptParser
extends SimplePreparableReloadListener<Map<ResourceLocation, ThingScript>> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ScriptParser instance = new ScriptParser();
    public static final String SCRIPTS_FOLDER = "scripts";
    public static final int SCRIPTS_FOLDER_LENGTH = "scripts".length();
    public static final String JS_EXTENSION = ".js";
    public static final int JS_EXTENSION_LENGTH = ".js".length();
    private static boolean enabled = false;
    private Map<ResourceLocation, ThingScript> scripts = new HashMap<ResourceLocation, ThingScript>();

    public static ScriptParser instance() {
        return instance;
    }

    public static void enable(ThingResourceManager manager) {
        if (!enabled) {
            manager.addResourceReloadListener((PreparableReloadListener)ScriptParser.instance());
            enabled = true;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    protected Map<ResourceLocation, ThingScript> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Collection resources = pResourceManager.m_6540_(SCRIPTS_FOLDER, t -> t.endsWith(JS_EXTENSION));
        HashMap<ResourceLocation, ThingScript> map = new HashMap<ResourceLocation, ThingScript>();
        for (ResourceLocation res : resources) {
            String path = res.m_135815_();
            String cleanPath = path.substring(SCRIPTS_FOLDER_LENGTH + 1, path.length() - JS_EXTENSION_LENGTH);
            ResourceLocation id = new ResourceLocation(res.m_135827_(), cleanPath);
            try {
                map.put(id, RhinoThingScript.fromResource(pResourceManager.m_142591_(res)));
            }
            catch (IOException | ScriptException e) {
                LOGGER.error("Error parsing script " + res, (Throwable)e);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, ThingScript> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.scripts = pObject;
    }

    @Nonnull
    public ThingScript getEvent(ResourceLocation id) {
        if (!this.scripts.containsKey(id)) {
            throw new KeyNotFoundException("Script with id " + id + " not found.");
        }
        return this.scripts.get(id);
    }
}

