/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino.dsl;

import com.mojang.logging.LogUtils;
import dev.latvian.mods.rhino.ConsString;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJSON;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.SharedContextData;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

public class DSLHelpers {
    private static Logger LOGGER = LogUtils.getLogger();

    public static <T extends IForgeRegistryEntry<T>> T find(IForgeRegistry<T> reg, String n) {
        ResourceLocation rl = new ResourceLocation(n);
        if (!reg.containsKey(rl)) {
            throw new RuntimeException("Cannot find effect with name " + rl);
        }
        return (T)reg.getValue(rl);
    }

    public static <T> T find(Registry<T> reg, String n) {
        ResourceLocation rl = new ResourceLocation(n);
        if (!reg.m_7804_(rl)) {
            throw new RuntimeException("Cannot find effect with name " + rl);
        }
        return (T)reg.m_7745_(rl);
    }

    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(Object arg, IForgeRegistry<T> reg) {
        Object object;
        if (arg instanceof String) {
            String str = (String)arg;
            object = DSLHelpers.find(reg, str);
        } else {
            object = (IForgeRegistryEntry)DSLHelpers.get(arg);
        }
        return (T)object;
    }

    public static <T> T getRegistryEntry(Object arg, Registry<T> reg) {
        T t;
        if (arg instanceof String) {
            String str = (String)arg;
            t = DSLHelpers.find(reg, str);
        } else {
            t = DSLHelpers.get(arg);
        }
        return t;
    }

    public static <T> T get(Object arg) {
        return (T)((NativeJavaObject)arg).unwrap();
    }

    public static <T> T get(Object arg, Class<T> target) {
        return target.cast(((NativeJavaObject)arg).unwrap());
    }

    public static byte getByte(Object arg) {
        return ((Number)arg).byteValue();
    }

    public static short getShort(Object arg) {
        return ((Number)arg).shortValue();
    }

    public static int getInt(Object arg) {
        return ((Number)arg).intValue();
    }

    public static long getLong(Object arg) {
        return ((Number)arg).longValue();
    }

    public static float getFloat(Object arg) {
        return ((Number)arg).floatValue();
    }

    public static double getDouble(Object arg) {
        return ((Number)arg).doubleValue();
    }

    public static String getString(Object arg) {
        return (String)arg;
    }

    public static Component getComponent(Context cx, Object arg) {
        if (arg instanceof NativeJavaObject) {
            NativeJavaObject o = (NativeJavaObject)arg;
            arg = o.unwrap();
        }
        if (arg instanceof String) {
            String s = (String)arg;
            return new TextComponent(s);
        }
        if (arg instanceof ConsString) {
            ConsString cs = (ConsString)arg;
            return new TextComponent(cs.toString());
        }
        if (arg instanceof NativeObject) {
            NativeObject obj = (NativeObject)arg;
            return Component.Serializer.m_130701_((String)NativeJSON.stringify((SharedContextData)cx.sharedContextData, (Object)obj, null, (Object)0));
        }
        return new TextComponent("unknown");
    }

    public static Object wrap(Scriptable scope, Object arg) {
        return DSLHelpers.wrap(scope, arg, null);
    }

    public static <T> Object wrap(Scriptable scope, T value, @Nullable Class<? super T> fieldType) {
        scope = ScriptableObject.getTopLevelScope((Scriptable)scope);
        Context cx = Context.getContext();
        return cx.sharedContextData.getWrapFactory().wrap(cx.sharedContextData, scope, value, fieldType);
    }

    public static void debugDumpBindings() {
        DSLHelpers.debugDumpBindings(Item.class);
        DSLHelpers.debugDumpBindings(Items.class);
        DSLHelpers.debugDumpBindings(ItemStack.class);
        DSLHelpers.debugDumpBindings(Block.class);
        DSLHelpers.debugDumpBindings(Blocks.class);
        DSLHelpers.debugDumpBindings(BlockState.class);
        DSLHelpers.debugDumpBindings(Enchantment.class);
        DSLHelpers.debugDumpBindings(Enchantments.class);
        DSLHelpers.debugDumpBindings(EnchantmentHelper.class);
        DSLHelpers.debugDumpBindings(MobEffect.class);
        DSLHelpers.debugDumpBindings(MobEffects.class);
        DSLHelpers.debugDumpBindings(MobEffectInstance.class);
        DSLHelpers.debugDumpBindings(Level.class);
        DSLHelpers.debugDumpBindings(Tag.class);
        DSLHelpers.debugDumpBindings(ByteTag.class);
        DSLHelpers.debugDumpBindings(ShortTag.class);
        DSLHelpers.debugDumpBindings(IntTag.class);
        DSLHelpers.debugDumpBindings(LongTag.class);
        DSLHelpers.debugDumpBindings(FloatTag.class);
        DSLHelpers.debugDumpBindings(DoubleTag.class);
        DSLHelpers.debugDumpBindings(StringTag.class);
        DSLHelpers.debugDumpBindings(ListTag.class);
        DSLHelpers.debugDumpBindings(CompoundTag.class);
        DSLHelpers.debugDumpBindings(ByteArrayTag.class);
        DSLHelpers.debugDumpBindings(IntArrayTag.class);
        DSLHelpers.debugDumpBindings(LongArrayTag.class);
    }

    public static void debugDumpBindings(Class<?> cls) {
        boolean isStatic;
        int mod;
        LOGGER.info("Dumping class bindings for " + cls.getCanonicalName());
        LOGGER.info("Static wrapper: ");
        for (Method method : cls.getDeclaredMethods()) {
            mod = method.getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || !isStatic) continue;
            LOGGER.info("m {}", (Object)method.getName());
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            mod = ((Field)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || !isStatic) continue;
            LOGGER.info("f {}", (Object)((Field)accessibleObject).getName());
        }
        LOGGER.info("Instance wrapper: ");
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            mod = ((Method)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || isStatic) continue;
            LOGGER.info("m {}", (Object)((Method)accessibleObject).getName());
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            mod = ((Field)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || isStatic) continue;
            LOGGER.info("f {}", (Object)((Field)accessibleObject).getName());
        }
    }
}

