/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockTinyPotato;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TileTinyPotato
extends TileExposedSimpleInventory
implements Nameable {
    private static final ResourceLocation BIRTHDAY_ADVANCEMENT = ResourceLocationHelper.prefix("challenge/tiny_potato_birthday");
    private static final boolean IS_BIRTHDAY = TileTinyPotato.isTinyPotatoBirthday();
    private static final String TAG_NAME = "name";
    private static final int JUMP_EVENT = 0;
    public int jumpTicks = 0;
    public Component name = new TextComponent("");
    private int nextDoIt = 0;
    private int birthdayTick = 0;
    private static final List<Block> ALL_CANDLE_CAKES = List.of(Blocks.f_152526_, Blocks.f_152527_, Blocks.f_152528_, Blocks.f_152529_, Blocks.f_152530_, Blocks.f_152531_, Blocks.f_152532_, Blocks.f_152533_, Blocks.f_152534_, Blocks.f_152535_, Blocks.f_152536_, Blocks.f_152485_, Blocks.f_152486_, Blocks.f_152487_, Blocks.f_152488_, Blocks.f_152489_, Blocks.f_152525_);

    public TileTinyPotato(BlockPos pos, BlockState state) {
        super(ModTiles.TINY_POTATO, pos, state);
    }

    public void interact(Player player, InteractionHand hand, ItemStack stack, Direction side) {
        if (!this.f_58857_.f_46443_) {
            int index = side.m_122411_();
            ItemStack stackAt = this.getItemHandler().m_8020_(index);
            if (!stackAt.m_41619_() && stack.m_41619_()) {
                player.m_21008_(hand, stackAt);
                this.getItemHandler().m_6836_(index, ItemStack.f_41583_);
            } else if (!stack.m_41619_()) {
                ItemStack copy = stack.m_41620_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, stackAt);
                } else if (!stackAt.m_41619_()) {
                    player.m_150109_().m_150079_(stackAt);
                }
                this.getItemHandler().m_6836_(index, copy);
            }
            this.jump();
            if (this.name.getString().toLowerCase(Locale.ROOT).trim().endsWith("shia labeouf") && this.nextDoIt == 0) {
                this.nextDoIt = 40;
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.doit, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                ItemStack son = this.getItemHandler().m_8020_(i);
                if (son.m_41619_() || !son.m_150930_(ModBlocks.tinyPotato.m_5456_())) continue;
                player.m_6352_((Component)new TextComponent("Don't talk to me or my son ever again."), Util.f_137441_);
                return;
            }
            player.m_36220_(ModStats.TINY_POTATOES_PETTED);
            PlayerHelper.grantCriterion((ServerPlayer)player, ResourceLocationHelper.prefix("main/tiny_potato_pet"), "code_triggered");
        }
    }

    private void jump() {
        if (this.jumpTicks == 0) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 20);
        }
    }

    public boolean m_7531_(int id, int param) {
        if (id == 0) {
            this.jumpTicks = param;
            return true;
        }
        return super.m_7531_(id, param);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileTinyPotato self) {
        if (self.jumpTicks > 0) {
            --self.jumpTicks;
        }
        if (!level.f_46443_) {
            if (level.f_46441_.nextInt(100) == 0) {
                self.jump();
            }
            if (self.nextDoIt > 0) {
                --self.nextDoIt;
            }
            if (IS_BIRTHDAY) {
                self.tickBirthday();
            }
        }
    }

    private void tickBirthday() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos facingPos = this.m_58899_().m_142300_(facing);
        if (this.f_58857_.m_46805_(facingPos)) {
            BlockState facingState = this.f_58857_.m_8055_(facingPos);
            DyeColor cakeColor = TileTinyPotato.getLitCakeColor(facingState, this.f_58857_.m_5822_());
            List<Player> players = PlayerHelper.getRealPlayersIn(this.f_58857_, VecHelper.boxForRange(Vec3.m_82512_((Vec3i)this.m_58899_()), 8.0));
            if (cakeColor != null && !players.isEmpty()) {
                ++this.birthdayTick;
                List<Integer> messageTimes = List.of(Integer.valueOf(100), Integer.valueOf(170), Integer.valueOf(240), Integer.valueOf(310), Integer.valueOf(380));
                int messageIndex = messageTimes.indexOf(this.birthdayTick);
                if (messageIndex != -1) {
                    Object[] objectArray;
                    if (messageIndex == 1) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TileTinyPotato.getTinyPotatoAge();
                    } else {
                        objectArray = ObjectArrays.EMPTY_ARRAY;
                    }
                    Object[] args = objectArray;
                    MutableComponent message = new TextComponent("<").m_7220_(this.m_5446_()).m_130946_("> ").m_7220_((Component)new TranslatableComponent("botania.tater_birthday." + messageIndex, args));
                    for (Player player : players) {
                        player.m_6352_((Component)message, Util.f_137441_);
                    }
                    this.jump();
                    BlockTinyPotato.spawnHearts((ServerLevel)this.f_58857_, this.m_58899_());
                }
                if (messageIndex == messageTimes.size() - 1) {
                    CompoundTag explosion = new CompoundTag();
                    explosion.m_128344_("Type", (byte)FireworkRocketItem.Shape.LARGE_BALL.m_41236_());
                    explosion.m_128379_("Flicker", true);
                    explosion.m_128379_("Trail", true);
                    explosion.m_128408_("Colors", List.of(Integer.valueOf(cakeColor.m_41070_()), Integer.valueOf(13787301), Integer.valueOf(14987213), Integer.valueOf(0xFEFEFE), Integer.valueOf(5754616)));
                    ListTag explosions = new ListTag();
                    explosions.add((Object)explosion);
                    ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
                    CompoundTag rocketFireworks = rocket.m_41698_("Fireworks");
                    rocketFireworks.m_128344_("Flight", (byte)0);
                    rocketFireworks.m_128365_("Explosions", (Tag)explosions);
                    this.f_58857_.m_7967_((Entity)new FireworkRocketEntity(this.f_58857_, (double)facingPos.m_123341_() + 0.5, (double)facingPos.m_123342_() + 0.5, (double)facingPos.m_123343_() + 0.5, rocket));
                    this.f_58857_.m_7471_(facingPos, false);
                    this.f_58857_.m_46796_(2001, facingPos, Block.m_49956_((BlockState)facingState));
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11912_, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                    for (Player player : players) {
                        PlayerHelper.grantCriterion((ServerPlayer)player, BIRTHDAY_ADVANCEMENT, "code_triggered");
                    }
                }
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        cmp.m_128359_(TAG_NAME, Component.Serializer.m_130703_((Component)this.name));
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        this.name = Component.Serializer.m_130701_((String)cmp.m_128461_(TAG_NAME));
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(6){

            public int m_6893_() {
                return 1;
            }
        };
    }

    @Nonnull
    public Component m_7755_() {
        return ModBlocks.tinyPotato.m_49954_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name.getString().isEmpty() ? null : this.name;
    }

    @Nonnull
    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_7755_();
    }

    @Nullable
    private static DyeColor getLitCakeColor(BlockState state, Random rand) {
        int idx = ALL_CANDLE_CAKES.indexOf(state.m_60734_());
        if (idx == -1) {
            return null;
        }
        if (!((Boolean)state.m_61143_((Property)CandleCakeBlock.f_152850_)).booleanValue()) {
            return null;
        }
        if (idx == 16) {
            return DyeColor.m_41053_((int)rand.nextInt(16));
        }
        return DyeColor.m_41053_((int)idx);
    }

    private static boolean isTinyPotatoBirthday() {
        LocalDateTime now = LocalDateTime.now();
        return now.getMonth() == Month.JULY && now.getDayOfMonth() == 19;
    }

    private static int getTinyPotatoAge() {
        LocalDateTime now = LocalDateTime.now();
        return now.getYear() - 2014;
    }
}

