/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipeBrew
implements IBrewRecipe {
    private final ResourceLocation id;
    private final Brew brew;
    private final NonNullList<Ingredient> inputs;

    public RecipeBrew(ResourceLocation id, Brew brew, Ingredient ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs);
    }

    public boolean m_5818_(Container inv, @Nonnull Level world) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.m_6643_() && !(stack = inv.m_8020_(i)).m_41619_(); ++i) {
            if (stack.m_41720_() instanceof IBrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.brewery);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IBrewContainer)) {
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        IBrewContainer container = (IBrewContainer)item;
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RecipeBrew && this.brew == ((RecipeBrew)o).brew && this.inputs.equals(((RecipeBrew)o).inputs);
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeBrew> {
        @Nonnull
        public RecipeBrew fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            String brewStr = GsonHelper.m_13906_((JsonObject)json, (String)"brew");
            ResourceLocation brewId = ResourceLocation.m_135820_((String)brewStr);
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().m_6612_(brewId).orElseThrow(() -> new JsonParseException("Unknown brew " + brewStr));
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new RecipeBrew(id, brew, inputs.toArray(new Ingredient[0]));
        }

        public RecipeBrew fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
            ResourceLocation brewId = buf.m_130281_();
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(brewId);
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            return new RecipeBrew(id, brew, inputs);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull RecipeBrew recipe) {
            ResourceLocation brewId = BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)recipe.getBrew());
            buf.m_130085_(brewId);
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
        }
    }
}

