/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;

public class CosmeticAttachRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new SimpleRecipeSerializer(CosmeticAttachRecipe::new);

    public CosmeticAttachRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundCosmetic = false;
        boolean foundAttachable = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICosmeticBauble && !foundCosmetic) {
                foundCosmetic = true;
                continue;
            }
            if (foundAttachable) continue;
            Item item = stack.m_41720_();
            if (item instanceof ICosmeticAttachable) {
                ICosmeticAttachable attachable = (ICosmeticAttachable)item;
                if (!(stack.m_41720_() instanceof ICosmeticBauble) && attachable.getCosmeticItem(stack).m_41619_()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundCosmetic && foundAttachable;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        Item stack;
        ItemStack cosmeticItem = ItemStack.f_41583_;
        ItemStack attachableItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICosmeticBauble && cosmeticItem.m_41619_()) {
                cosmeticItem = stack;
                continue;
            }
            attachableItem = stack;
        }
        stack = attachableItem.m_41720_();
        if (!(stack instanceof ICosmeticAttachable)) {
            return ItemStack.f_41583_;
        }
        ICosmeticAttachable attachable = (ICosmeticAttachable)stack;
        if (!attachable.getCosmeticItem(attachableItem).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = attachableItem.m_41777_();
        attachable.setCosmeticItem(copy, cosmeticItem);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

