/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorBeardifier;
import vazkii.botania.mixin.AccessorNoiseChunk;

public class SkyblockChunkGenerator
extends ChunkGenerator {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> SkyblockChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(gen -> gen.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.settings))).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    protected final BlockState defaultBlock;
    private final Registry<NormalNoise.NoiseParameters> noises;
    protected final long seed;
    protected final Holder<NoiseGeneratorSettings> settings;
    private final NoiseRouter router;
    protected final Climate.Sampler sampler;
    private final Aquifer.FluidPicker globalFluidPicker;

    public static void init() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)ResourceLocationHelper.prefix("skyblock"), CODEC);
    }

    public static boolean isWorldSkyblock(Level world) {
        return world.m_7726_() instanceof ServerChunkCache && ((ServerChunkCache)world.m_7726_()).m_8481_() instanceof SkyblockChunkGenerator;
    }

    public static ChunkGenerator createForWorldType(RegistryAccess registryAccess, long seed) {
        return new SkyblockChunkGenerator((Registry<StructureSet>)registryAccess.m_175515_(Registry.f_211073_), (Registry<NormalNoise.NoiseParameters>)registryAccess.m_175515_(Registry.f_194568_), (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(registryAccess.m_175515_(Registry.f_122885_)), seed, (Holder<NoiseGeneratorSettings>)registryAccess.m_175515_(Registry.f_122878_).m_206081_(NoiseGeneratorSettings.f_64432_));
    }

    private SkyblockChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> settings) {
        this(structureSets, noises, biomeSource, biomeSource, seed, settings);
    }

    private SkyblockChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, BiomeSource runtimeBiomeSource, long seed, Holder<NoiseGeneratorSettings> settings) {
        super(structureSets, Optional.empty(), biomeSource, runtimeBiomeSource, seed);
        this.noises = noises;
        this.seed = seed;
        this.settings = settings;
        NoiseGeneratorSettings genSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        this.defaultBlock = genSettings.f_64440_();
        this.router = genSettings.m_209366_(noises, seed);
        this.sampler = new Climate.Sampler(this.router.f_209384_(), this.router.f_209385_(), this.router.f_209386_(), this.router.f_209387_(), this.router.f_209388_(), this.router.f_209389_(), this.router.f_209395_());
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = genSettings.f_64444_();
        Aquifer.FluidStatus defaultFluid = new Aquifer.FluidStatus(i, genSettings.f_64441_());
        this.globalFluidPicker = (p_198228_, p_198229_, p_198230_) -> p_198229_ < Math.min(-54, i) ? lava : defaultFluid;
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> biomes, Executor p_197006_, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            this.doCreateBiomes(blender, structureFeatureManager, chunkAccess);
            return chunkAccess;
        }), Util.m_183991_());
    }

    private void doCreateBiomes(Blender blender, StructureFeatureManager sfm, ChunkAccess chunkAccess) {
        NoiseChunk chunk = chunkAccess.m_207937_(this.router, () -> AccessorBeardifier.botania_make(sfm, chunkAccess), (NoiseGeneratorSettings)this.settings.m_203334_(), this.globalFluidPicker, blender);
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_204531_((BiomeResolver)blender.m_183383_((BiomeResolver)this.f_62138_), (ChunkAccess)chunkAccess);
        chunkAccess.m_183442_(biomeresolver, ((AccessorNoiseChunk)chunk).botania_cachedClimateSampler(this.router));
    }

    @VisibleForDebug
    public NoiseRouter router() {
        return this.router;
    }

    public Climate.Sampler m_183403_() {
        return this.sampler;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new SkyblockChunkGenerator((Registry<StructureSet>)this.f_207955_, this.noises, this.f_62137_.m_7206_(seed), seed, this.settings);
    }

    public int m_142647_(int x, int z, Heightmap.Types heightmapTypes, LevelHeightAccessor levelHeightAccessor) {
        return levelHeightAccessor.m_141937_();
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor levelHeightAccessor) {
        return new NoiseColumn(levelHeightAccessor.m_141937_(), new BlockState[0]);
    }

    public void m_207076_(List<String> strings, BlockPos pos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        DensityFunction.SinglePointContext spc = new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        double d0 = this.router.f_209389_().m_207386_((DensityFunction.FunctionContext)spc);
        strings.add("NoiseRouter T: " + decimalformat.format(this.router.f_209384_().m_207386_((DensityFunction.FunctionContext)spc)) + " H: " + decimalformat.format(this.router.f_209385_().m_207386_((DensityFunction.FunctionContext)spc)) + " C: " + decimalformat.format(this.router.f_209386_().m_207386_((DensityFunction.FunctionContext)spc)) + " E: " + decimalformat.format(this.router.f_209387_().m_207386_((DensityFunction.FunctionContext)spc)) + " D: " + decimalformat.format(this.router.f_209388_().m_207386_((DensityFunction.FunctionContext)spc)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(TerrainShaper.m_187265_((float)((float)d0))) + " AS: " + decimalformat.format(this.router.f_209390_().m_207386_((DensityFunction.FunctionContext)spc)) + " N: " + decimalformat.format(this.router.f_209391_().m_207386_((DensityFunction.FunctionContext)spc)));
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structures, ChunkAccess chunk) {
    }

    public void m_183516_(WorldGenRegion worldGenRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    public void m_6929_(WorldGenRegion region) {
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess chunkAccess, StructureFeatureManager structureFeatureManager) {
    }
}

