/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.Modifier;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class SoulDevouring
extends Modifier {
    private final ResourceLocation KEY = new ResourceLocation("tinkers_ingenuity", "soul");

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.KEY);
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        ModDataNBT toolData = tool.getPersistentData();
        LivingEntity target = context.getLivingTarget();
        if (target != null && target.m_21224_() && damageDealt > 0.0f && !(target instanceof Player)) {
            if (toolData.contains(this.KEY, 5)) {
                toolData.putFloat(this.KEY, toolData.getFloat(this.KEY) + 0.2f);
            } else {
                toolData.putFloat(this.KEY, 0.2f * (float)level);
            }
        }
        return super.afterEntityHit(tool, level, context, damageDealt);
    }

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        ModDataNBT toolData = tool.getPersistentData();
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            float value = toolData.getFloat(this.KEY);
            return damage + value;
        }
        return super.getEntityDamage(tool, level, context, baseDamage, damage);
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT toolData = tool.getPersistentData();
            if (toolData.contains(this.KEY, 5)) {
                this.addDamageTooltip(tool, toolData.getFloat(this.KEY), tooltip);
            } else {
                this.addDamageTooltip(tool, 0.0f, tooltip);
            }
        }
    }
}

