#version 120

#define AO 2 //[0 1 2 3]
#define BrightEmissive
//#define BumpyEdge
//#define Celshade
#define Desaturation
//#define DisableTexture
#define Fog
//#define LightmapBanding
#define LightShafts 1 //[0 1 2]
//#define RoundSunMoon
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
//#define ShadowColor
//#define ShadowLeakFix
#define SkyDesaturation
#define Stars
#define WaterCaustic 0 //[0 1 2]
#define WaterFog
//#define WorldCurvature
#define WorldCurvatureSize 1024		// [32 64 128 256 512 1024 2048 4096 8192]
//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

#define StrLDay 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrLNight 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrLRain 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSDay 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSNight 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSRain 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTNormal 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTBright 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

const int shadowMapResolution = 2048; //[512 1024 2048 4096 8192]
const float shadowDistance = 256.0; //[128.0 256.0 512.0]
const float shadowDistanceRenderMul = 1.0;

#define SHADOW_MAP_BIAS 0.90
const float sunPathRotation = -40.0;
const float eyeBrightnessHalflife = 10.0f;
const int noiseTextureResolution  = 1024;
const bool shadowHardwareFiltering = true;
const float drynessHalflife = 10.0f;
const float wetnessHalflife = 15.0f;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform sampler2DShadow shadowtex0;
#ifdef ShadowColor
uniform sampler2DShadow shadowtex1;
uniform sampler2DShadow shadowcolor;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform float blindness;
uniform float nightVision;
uniform int isEyeInWater;
uniform int worldTime;
uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform float far;
uniform float near;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,pow(length(c),0.2)*rain,rainStrength);
}

float calcLightIntensity(float day, float night, float rain){
	return mix(mix(night,day,sunVisibility),rain*(0.2+0.8*sunVisibility),rainStrength);
}

float getSSS(vec3 normal, vec3 lightVector, vec3 fragpos){
	return max(dot(-normal,lightVector),0.0)*pow(max(dot(normalize(fragpos),normalize(lightVector)),0.0),25.0)*(1.0-rainStrength);
}

float edepth(sampler2D depth, vec2 coord) {
	return texture2D(depth,coord).r;
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither8x8(vec2 pos)
{
	const int ditherPattern[64] = int[64](
		0, 32, 8, 40, 2, 34, 10, 42,
		48, 16, 56, 24, 50, 18, 58, 26,
		12, 44, 4, 36, 14, 46, 6, 38,
		60, 28, 52, 20, 62, 30, 54, 22,
		3, 35, 11, 43, 1, 33, 9, 41,
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

    vec2 positon = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 8.0f));

	int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

	return float(dither) / 64.0f;
}

float Blinn_Phong(vec3 ppos, vec3 lightDir, vec3 surfaceNormal, float gloss, float visibility)  {
	vec3 viewDirection = normalize(-ppos);
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return pow(blinnTerm, n )*sqrt(gloss)*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 8.0).r*0.2;

	return noise;
	}

float getCaustic(vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float caustic = max((1.0-abs(0.5-h0))*(1.0-(abs(h1-h2)+abs(h3-h4))),0.0);
		  caustic = max(pow(caustic,3.5),0.0)*2.0;
		  
	return caustic;
}

vec3 getSunMoon(vec3 fragpos, vec3 morning, vec3 day, vec3 night){
	float NdotS = dot(normalize(fragpos),normalize(sunVec));
	float issun = float(NdotS > 0.0);
	float sunmoon = pow(abs(NdotS),1200.0-400.0*issun)*(1.0-rainStrength);
	vec3 lightcol = mix(night*moonVisibility,mix(morning,day,pow(tB,0.75))*sunVisibility,issun)*16.0;
	
	return sunmoon*lightcol;
}

vec3 getStars(vec3 fragpos, vec3 light_n){
	vec3 wpos = vec3(gbufferModelViewInverse * vec4(fragpos,1.0));
	vec3 intersection = wpos/(wpos.y+length(wpos.xz));
	vec2 wind = vec2(frametime,0.0);
	vec2 coord = intersection.xz*0.3+cameraPosition.xz*0.0001+wind*0.00125;
	
	float cosT = pow(max(dot(normalize(fragpos),normalize(upVec)),0.0),0.25);
	
	float star = texture2D(noisetex,coord.xy).r;
		  star*= texture2D(noisetex,coord.xy+0.1).r;
		  star*= texture2D(noisetex,coord.xy+0.23).r;
		  star*= texture2D(noisetex,coord.xy+0.456).r;
		  star*= texture2D(noisetex,coord.xy+0.7891).r;
		  star = max(star-0.2,0.0)*10.0*cosT*(1.0-rainStrength)*moonVisibility;
		
	return star*pow(light_n,vec3(0.8));
}

#include "lib/colorRange.glsl"
#include "lib/fragPos.glsl"
#include "lib/shadowPos.glsl"
#include "lib/shadows.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/clouds.glsl"
#include "lib/celShading.glsl"
#include "lib/ambientOcclusion.glsl"

float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec4 getShadowSpace(float shadowdepth, vec2 texcoord){
	vec4 fragpos = getFragPos(texcoord.xy,shadowdepth);

	vec4 wpos = getWorldPos(fragpos);
	wpos = getShadowPos(wpos);
	
	float distb = sqrt(wpos.x * wpos.x + wpos.y * wpos.y);
	float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
	wpos = distortShadow(wpos,distortFactor);
	
	return wpos;
}

vec3 getVolumetricRays(float pixeldepth) {
	vec3 vl = vec3(0.0);
	float samples = mix(32.0,16.0,eBS);
	float slength = far/samples;
	float dither = dither8x8(texcoord.xy);
	
	dither *= slength;

	float maxDist = far;
	float minDist = 0.01f+dither;
	vec4 worldposition = vec4(0.0);

	for (minDist; minDist < maxDist; ) {
		if (getDepth(pixeldepth) < minDist){
			break;
		}
		worldposition = getShadowSpace(distx(minDist),texcoord.st);
		if (length(worldposition.xy*2.0-1.0)>1.0) break;
		vec3 sample = vec3(shadow2D(shadowtex0, vec3(worldposition.rg, worldposition.b)).z);
		vec3 colsample = vec3(0.0);
		#ifdef ShadowColor
		float testsample = shadow2D(shadowtex1, vec3(worldposition.rg, worldposition.b)).z;
		if (testsample-sample.r > 0) colsample = shadow2D(shadowcolor, vec3(worldposition.rg, worldposition.b)).rgb*4.0;
		#endif
		vl += pow(max(sample,colsample),vec3(2.2));
		minDist = minDist + slength;
}
	vl = vl/samples;
	
	return vec3(vl);
}

float getnoise(vec2 pos){
	return fract(sin(dot(pos, vec2(12.9898, 4.1414))) * 43758.5453);
}

float hnoise(vec2 pos){
	vec2 flr = floor(pos);
	vec2 frc = fract(pos);
	frc = frc*frc*(3-2*frc);
	
	float noisedl = getnoise(flr);
	float noisedr = getnoise(flr+vec2(1.0,0.0));
	float noiseul = getnoise(flr+vec2(0.0,1.0));
	float noiseur = getnoise(flr+vec2(1.0,1.0));
	float noise= mix(mix(noisedl,noisedr,frc.x),mix(noiseul,noiseur,frc.x),frc.y);
	return noise;
}

float vcnoise(vec3 pos){
	vec3 flr = floor(pos);
	vec3 frc = fract(pos);
	float yadd = 32.0;
	frc = frc*frc*(3.0-2.0*frc);
	
	/*
	float noise = getnoise(flr.xz+flr.y*yadd);
	return noise
	*/
	
	float noisebdl = getnoise(flr.xz+flr.y*yadd);
	float noisebdr = getnoise(flr.xz+flr.y*yadd+vec2(1.0,0.0));
	float noisebul = getnoise(flr.xz+flr.y*yadd+vec2(0.0,1.0));
	float noisebur = getnoise(flr.xz+flr.y*yadd+vec2(1.0,1.0));
	float noisetdl = getnoise(flr.xz+flr.y*yadd+yadd);
	float noisetdr = getnoise(flr.xz+flr.y*yadd+yadd+vec2(1.0,0.0));
	float noisetul = getnoise(flr.xz+flr.y*yadd+yadd+vec2(0.0,1.0));
	float noisetur = getnoise(flr.xz+flr.y*yadd+yadd+vec2(1.0,1.0));
	float noise= mix(mix(mix(noisebdl,noisebdr,frc.x),mix(noisebul,noisebur,frc.x),frc.z),mix(mix(noisetdl,noisetdr,frc.x),mix(noisetul,noisetur,frc.x),frc.z),frc.y);
	return noise;
}

float getVCSample(vec3 pos, float h, float t, float s){
	float noise = 0.0;
	float ymult = pow(abs(h-pos.y)/t,2.0);
	vec3 wind = vec3(frametime,0.0,0.0);
	
	if (ymult < 2.0){
		noise+= vcnoise(pos/s*0.5-wind*0.5);
		noise+= vcnoise(pos/s*0.25-wind*0.4)*2.0;
		noise+= vcnoise(pos/s*0.125-wind*0.3)*3.0;
		noise+= vcnoise(pos/s*0.0625-wind*0.2)*4.0;
		noise+= vcnoise(pos/s*0.03125-wind*0.1)*5.0;
		noise+= vcnoise(pos/s*0.016125)*6.0;
	}
	noise = clamp(mix(noise,21.0,0.25*rainStrength)-(10.0+5.0*ymult),0.0,1.0);
	return noise;
}

vec2 getVolumetricCloud(float pixeldepth, float pixeldepthw) {
	float h = 128.0;
	float t = 16.0;
	float s = 1.0;
	
	vec2 vc = vec2(0.0);
	float slength = 8.0;
	float dither = dither8x8(texcoord.xy)*slength;

	float maxDist = 2.0*far;
	float minDist = 0.01f+dither;
	vec4 wpos = vec4(0.0);

	for (minDist; minDist < maxDist; ) {
		if (getDepth(pixeldepth) < minDist || vc.y > 0.999){
			break;
		}
		wpos = getWorldPos(getFragPos(texcoord.xy,distx(minDist)));
		if (length(wpos.xz) < maxDist){
			float vh = hnoise((wpos.xz+cameraPosition.xz+frametime)*0.005);
			#ifdef WorldCurvature
			if (length(wpos.xz)<WorldCurvatureSize) wpos.y += length(wpos.xz)*length(wpos.xyz)/WorldCurvatureSize;
			else break;
			#endif
			wpos.xyz += cameraPosition.xyz + vec3(frametime*4.0,-vh*32.0,0.0);
			float noise = getVCSample(wpos.xyz,h,t,s);
			float col = pow(smoothstep(h-t*noise,h+t*noise,wpos.y),1.5);
			vc.x = max(noise*col,vc.x);
			vc.y = max(noise,vc.y);
		}
		minDist = minDist + slength;
	}
	return vc;
}

void main() {
	
	vec3 color = pow(max(texture2D(colortex0, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2));
	vec3 aux = texture2D(colortex4, texcoord.st).rgb;
	vec3 wateraux = texture2D(colortex5, texcoord.st).rgb;
	float ao = 1.0;
	float spec = 0.0;
	vec2 vc = vec2(0.0);
	
	#ifdef LightmapBanding
	aux = vec3(floor(aux.r*16.0)/16.0,aux.g,floor(aux.b*16.0)/16.0);
	#endif
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float wmatflag = wateraux.g;
	float torchmap = pow(aux.b,2.2)*0.2*StrTNormal + pow(max(pow(aux.b,2.2)-0.5,0.0)*2.0,5.0)*StrTBright;
	
	float land = float(matflag > 0.05);
	float lava = float(matflag > 0.18 && matflag < 0.22);
	float metal = 0.0;
	float foliage = float(matflag > 0.38 && matflag < 0.42);
	float emissive = float(matflag > 0.48 && matflag < 0.52);
	
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	float translucent = float(wmatflag > 0.05);
	float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
	
	vec3 light = calcLightColor(light_m, light_d + vec3(0.0, 0.25, 1.0)*(1-lava), light_n, light_r);
	vec3 ambient = calcLightColor(sky_m, sky_d, sky_n, sky_r);
	
	float pixeldepth = texture2D(depthtex1,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (land > 0.9) {
		vec3 normal = texture2D(colortex2, texcoord.st).rgb*2.0-1.0;
		float specemissive = 0.0;
		
		#ifdef DisableTexture
		color = vec3(1.0,1.0,1.0)*0.4*(1.0+0.5*(emissive+lava));
		#endif
		
		vec4 worldpos = getWorldPos(fragpos);
		
		vec3 finallight = vec3(0);
		vec3 scenelight = vec3(0);
		vec3 inambient = vec3(0.8)*pow(skymap,0.5)*(0.5+0.5*tB)*(1.0-eBS)*(1.0-rainStrength*0.8)*(1.0-isEyeInWater)*(0.025+0.975*sunVisibility);
		vec3 torchlight = pow(torch_c,vec3(1.2-0.2*pow(aux.b,0.25)))*torchmap*8.0;
		
		#ifdef RPSupport
		#if RPSFormat == 0
		metal = float(matflag > 0.28 && matflag < 0.32);
		#endif
		#if RPSFormat == 1
		metal = texture2D(colortex6,texcoord.xy).g;
		#endif
		#if RPSFormat == 2
		metal = texture2D(colortex6,texcoord.xy).g;
		specemissive = pow(texture2D(colortex6,texcoord.xy).b,0.5);
		torchlight += color*8.0*specemissive;
		emissive *= 0.0;
		#endif
		#endif
		
		#ifdef BrightEmissive
		vec3 emissivelight = color*(emissive+lava)*8.0;
		#else
		vec3 emissivelight = vec3(0.0);
		#endif
		
		float NdotL = max(dot(normal, lightVector)*1.05-0.05,0.0);
		float NdotU = pow(dot(normal, upVec)*0.25+0.75,2.2);
		float shading = getShadows(shadowtex0, worldpos, NdotL, foliage);
		shading = max(shading*mix(max(NdotL,0.0), 1.0, foliage)*nolight,0.0);
		
		vec3 shadowcol = vec3(0.0);
		#ifdef ShadowColor
		if (shading < 0.999) shadowcol = getShadowsColor(worldpos, NdotL, foliage)*getShadows(shadowtex1, worldpos, NdotL, foliage)*NdotL;
		#endif
		
		#ifdef ShadowLeakFix
		float shadowfix = clamp(skymap*20.0-1.0,eBS,1.0);
		shading *= shadowfix;
		shadowcol *= shadowfix;
		#endif
		
		vec3 uw_tint = mix(vec3(1.0),pow(water_c,vec3((1.0-skymap*0.9)*2.0))*skymap,absorb)*(1.0+water);
		
		#if WaterCaustic == 1 || WaterCaustic == 2
		if (absorb > 0.9){
		vec3 causticcol = calcLightColor(light_m, light_d, pow(light_n,vec3(0.5))*4.0, light_r);
		vec3 causticpos = worldpos.xyz+cameraPosition.xyz;
		float caustic = getCaustic(causticpos);
		vec3 torchcaustic = caustic*2.0*pow(torch_c,vec3(0.5/2.2))*pow(aux.b,2.2);
		color *= 1.0+torchcaustic;
		#if WaterCaustic == 1 || (WaterCaustic == 2 && !(defined ShadowColor))
		vec3 lightcaustic = caustic*(0.5+0.5*skymap)*causticcol*shading;
		uw_tint *= 1.0+lightcaustic;
		#endif
		}
		#endif
		
		float sss = 0.0;
		if (foliage > 0.9){
			sss = getSSS(normal,lightVector,fragpos.xyz);
			NdotU *= 1.8;
		}
		
		#if AO == 1
		if (lava < 0.9 && water < 0.9) ao = dbaol(ao,depthtex1,fragpos.xyz);
		#endif
		#if AO == 2
		ao = dbaoh(depthtex1);
		#endif
		#if AO == 3
		ao = ssao(depthtex1,normal);
		#endif
		
		float minlight = 1.0/255.0 * (4.0-3.0*eBS);
		float exposure = mix(3.0+2.0*shading*(1.0-0.75*rainStrength),1.0,eBS);
		float lightmult = calcLightIntensity(StrLDay,StrLNight,StrLRain);
		float skymult = calcLightIntensity(StrSDay,StrSNight,StrSRain);
		scenelight = mix(((ambient+inambient)*skymult*skymap+minlight),light*lightmult*(1.0+3.0*sss),max(vec3(shading),shadowcol)*(1.0-0.9*rainStrength))*exposure;
		finallight = (scenelight*uw_tint+torchlight+nightVision)*ao*NdotU+emissivelight;
		
		color = color/sqrt(1.0+color*color);
		color *= finallight;
		
		color += max(Blinn_Phong(fragpos.xyz,lightVector,normal,1.0,shading),0.0)*light*nolight*(1.0-rainStrength)*0.0025*lightmult*(1.0-absorb);
		
		#ifdef Desaturation
		float ddesat = clamp(max(pow(shading,0.2),skymap)*sunVisibility*(1-rainStrength*0.8)+aux.b*1.25+emissive+lava+specemissive,0.15+0.05*skymap*(1.0-rainStrength),1.0);
		vec3 desat_c = mix(vec3(length(light_n))*sky_r,light_n,skymap*(1.0-rainStrength))*4.0;
		color = mix(luma(color)*desat_c,color,ddesat);
		#endif
		
		#ifdef Fog
		if (absorb < 0.9) color = calcFog(color, light, fragpos.xyz);
		#endif
		
		#ifdef RPSupport
		float smoothness = texture2D(colortex6,texcoord.xy).r;
		spec = Blinn_Phong(fragpos.xyz,lightVector,normal,1.0+(11.0+moonVisibility)*mix(smoothness,1.0,metal*0.5),shading);
		spec = spec/(1.0+spec);
		#endif
	}
	else{
	if (blindness < 0.999){
		#ifdef SkyDesaturation
		color = mix(length(color)*pow(light_n,vec3(0.8))*2.0,color,sunVisibility);
		#endif
		
		color = color*2.0;
		
		#if LightShafts == 2
		float cosS = dot(normalize(fragpos.xyz),normalize(lightVector));
		color += getSkyColor(fragpos.xyz,light)*mix(1.0,0.75,nolight*(cosS*0.5+0.5))*(1.0+nightVision);
		#else
		color += getSkyColor(fragpos.xyz, light)*(1.0+nightVision);
		#endif
		
		#ifdef RoundSunMoon
		color += getSunMoon(fragpos.xyz,light_m,light_d*pow(light_m,vec3(0.5)),pow(light_n,vec3(0.5))*2.0);
		#endif
		
		#ifdef Stars
		if (moonVisibility > 0.001) color += getStars(fragpos.xyz,light_n);
		#endif
		
		#if Clouds == 1
		color = drawCloud(fragpos.xyz,color,light,ambient);
		#endif
		}
	}
	
	#ifdef WaterFog
	if (absorb > 0.9 || (isEyeInWater > 0.9 && (translucent > 0.9 || land < 0.9) && water < 0.9)){
		float cosT = dot(normalize(fragpos.xyz),normalize(upVec));
		float wnofog = max(mix(clamp(cosT*32.0+1.5,0.0,1.0), skymap/mix(1.0,max(length(fragpos.xyz),1.0),isEyeInWater), land)-(1.0-eBS),0.0);
		vec3 wfog_c = water_c*mix(vec3(1.0),pow(light,vec3(0.2+0.7*moonVisibility)),eBS);
		color = calcWFog(color, wfog_c, cmult, wfogrange, wnofog, fragpos.xyz);
	}
	#endif
	
	if (wmatflag > 0.05){
		#ifdef Celshade
		color *= celshade(depthtex1,length(fragpos.xyz));
		#endif
		
		#ifdef BumpyEdge
		color = bumpyedge(color,depthtex1);
		#endif
		
		#if Clouds == 2
		float pixeldepthw = texture2D(depthtex0,texcoord.xy).x;
		vc = getVolumetricCloud(pixeldepth,pixeldepthw);
		#endif
		
		#ifdef Fog
		if (isEyeInWater > 1.9) color = calcLFog(color,fragpos.xyz);
		if (blindness > 0.001) color = calcBFog(color,blindness,fragpos.xyz);
		#endif
	}
	
/* DRAWBUFFERS:045 */
	
	gl_FragData[0] = vec4(rangeCompress(color),spec);
	gl_FragData[1] = vec4(aux,vc.x);
	gl_FragData[2] = vec4(wateraux,vc.y);

}
