#version 120

#define AO 2 //[0 1 2 3]
#define Clouds 1 //[0 1 2]
#define Desaturation
//#define DisableTexture
#define EmissiveRecolor
#define Fog
//#define LightmapBanding
#define LightShafts 1 //[0 1 2]
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
//#define ShadowColor
//#define ShadowLeakFix
#define TranslucentAO 1	//[0 1 2]
#define WaterFog
#define WaterRefraction
//#define WorldCurvature
#define WorldCurvatureSize 1024		// [32 64 128 256 512 1024 2048 4096 8192]
//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

#define StrLDay 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrLNight 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrLRain 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSDay 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSNight 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrSRain 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTNormal 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTBright 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

const int shadowMapResolution = 2048; //[512 1024 2048 4096 8192]
const float shadowDistance = 256.0; //[128.0 256.0 512.0]

#define SHADOW_MAP_BIAS 0.90
const bool colortex0MipmapEnabled = true;
const bool colortex4MipmapEnabled = true;
const bool colortex5MipmapEnabled = true;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;
varying float handRecolor;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex0;
#if LightShafts == 2 || Clouds == 2
uniform sampler2D depthtex1;
#endif
uniform sampler2D noisetex;

uniform sampler2DShadow shadowtex0;
#ifdef ShadowColor
uniform sampler2DShadow shadowtex1;
uniform sampler2DShadow shadowcolor;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform float nightVision;
uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,pow(length(c),0.2)*rain,rainStrength);
}

float calcLightIntensity(float day, float night, float rain){
	return mix(mix(night,day,sunVisibility),rain*(0.2+0.8*sunVisibility),rainStrength);
}

float edepth(sampler2D depth, vec2 coord) {
	return texture2D(depth,coord).r;
}

float Blinn_Phong(vec3 ppos, vec3 lightDir, vec3 surfaceNormal, float gloss, float visibility)  {
	vec3 viewDirection = normalize(-ppos);
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return pow(blinnTerm, n )*sqrt(gloss)*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

	noise /= pow(max(length(pos),4.0),0.4);
	return noise;
}

vec2 getRefract(vec2 coord, vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec2 newcoord = vec2(xDelta,yDelta)*0.01 + coord;
	float water = texture2D(colortex5, newcoord).g;
	water = float(water > 0.08 && water < 0.12);
	float limit = max(1.0-water,float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0));

	return mix(newcoord,coord,limit);
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither8x8(vec2 pos)
{
	const int ditherPattern[64] = int[64](
		0, 32, 8, 40, 2, 34, 10, 42,
		48, 16, 56, 24, 50, 18, 58, 26,
		12, 44, 4, 36, 14, 46, 6, 38,
		60, 28, 52, 20, 62, 30, 54, 22,
		3, 35, 11, 43, 1, 33, 9, 41,
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

    vec2 positon = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 8.0f));

	int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

	return float(dither) / 64.0f;
}

vec2 getGRCoord(vec2 coord, vec2 dcoord, float str){
	return coord - dcoord*dither8x8(texcoord.xy)*str;
}

#include "lib/colorRange.glsl"
#include "lib/fragPos.glsl"
#include "lib/shadowPos.glsl"
#include "lib/shadows.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/ambientOcclusion.glsl"

float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec4 getShadowSpace(float shadowdepth, vec2 texcoord){
	vec4 fragpos = getFragPos(texcoord.xy,shadowdepth);

	vec4 wpos = getWorldPos(fragpos);
	wpos = getShadowPos(wpos);
	
	float distb = sqrt(wpos.x * wpos.x + wpos.y * wpos.y);
	float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
	wpos = distortShadow(wpos,distortFactor);
	
	return wpos;
}

vec3 getVolumetricRays(float pixeldepth, vec3 color, float alpha, float water) {
	vec3 vl = vec3(0.0);
	float samples = mix(32.0,16.0,eBS);
	float slength = min(far,128.0)/samples;
	float dither = dither8x8(texcoord.xy);
	
	dither *= slength;

	float maxDist = min(far,128.0);
	float minDist = 0.01f+dither;
	vec4 worldposition = vec4(0.0);
	
	float pixeldepthb = texture2D(depthtex0,texcoord.xy).r;
	
	for (minDist; minDist < maxDist; ) {
		if (getDepth(pixeldepth) < minDist || (getDepth(pixeldepthb) < minDist && alpha > 0.99)){
			break;
		}
		worldposition = getShadowSpace(distx(minDist),texcoord.st);
		if (length(worldposition.xy*2.0-1.0)>1.0) break;
		vec3 sample = vec3(shadow2D(shadowtex0, vec3(worldposition.rg, worldposition.b)).z);
		vec3 colsample = vec3(0.0);
		#ifdef ShadowColor
		float testsample = shadow2D(shadowtex1, vec3(worldposition.rg, worldposition.b)).z;
		if (testsample-sample.r > 0) colsample = shadow2D(shadowcolor, vec3(worldposition.rg, worldposition.b)).rgb*4.0;
		#endif
		sample = pow(max(sample,colsample),vec3(2.2));
		if (getDepth(pixeldepthb) < minDist) sample *= mix(vec3(1.0),color,pow(alpha,mix(1.0/4.84,1.0/2.2,water)));
		vl += sample;
		minDist = minDist + slength;
}
	vl = vl/samples;
	
	return vec3(vl);
}

float getnoise(vec2 pos){
	return fract(sin(dot(pos, vec2(12.9898, 4.1414))) * 43758.5453);
}

float hnoise(vec2 pos){
	vec2 flr = floor(pos);
	vec2 frc = fract(pos);
	frc = frc*frc*(3-2*frc);
	
	float noisedl = getnoise(flr);
	float noisedr = getnoise(flr+vec2(1.0,0.0));
	float noiseul = getnoise(flr+vec2(0.0,1.0));
	float noiseur = getnoise(flr+vec2(1.0,1.0));
	float noise= mix(mix(noisedl,noisedr,frc.x),mix(noiseul,noiseur,frc.x),frc.y);
	return noise;
}

float vcnoise(vec3 pos){
	vec3 flr = floor(pos);
	vec3 frc = fract(pos);
	float yadd = 32.0;
	frc = frc*frc*(3.0-2.0*frc);
	
	/*
	float noise = getnoise(flr.xz+flr.y*yadd);
	return noise
	*/
	
	float noisebdl = getnoise(flr.xz+flr.y*yadd);
	float noisebdr = getnoise(flr.xz+flr.y*yadd+vec2(1.0,0.0));
	float noisebul = getnoise(flr.xz+flr.y*yadd+vec2(0.0,1.0));
	float noisebur = getnoise(flr.xz+flr.y*yadd+vec2(1.0,1.0));
	float noisetdl = getnoise(flr.xz+flr.y*yadd+yadd);
	float noisetdr = getnoise(flr.xz+flr.y*yadd+yadd+vec2(1.0,0.0));
	float noisetul = getnoise(flr.xz+flr.y*yadd+yadd+vec2(0.0,1.0));
	float noisetur = getnoise(flr.xz+flr.y*yadd+yadd+vec2(1.0,1.0));
	float noise= mix(mix(mix(noisebdl,noisebdr,frc.x),mix(noisebul,noisebur,frc.x),frc.z),mix(mix(noisetdl,noisetdr,frc.x),mix(noisetul,noisetur,frc.x),frc.z),frc.y);
	return noise;
}

float getVCSample(vec3 pos, float h, float t, float s){
	float noise = 0.0;
	float ymult = pow(abs(h-pos.y)/t,2.0);
	vec3 wind = vec3(frametime,0.0,0.0);
	
	if (ymult < 2.0){
		noise+= vcnoise(pos/s*0.5-wind*0.5);
		noise+= vcnoise(pos/s*0.25-wind*0.4)*2.0;
		noise+= vcnoise(pos/s*0.125-wind*0.3)*3.0;
		noise+= vcnoise(pos/s*0.0625-wind*0.2)*4.0;
		noise+= vcnoise(pos/s*0.03125-wind*0.1)*5.0;
		noise+= vcnoise(pos/s*0.016125)*6.0;
	}
	noise = clamp(mix(noise,21.0,0.15*wetness)-(10.0+5.0*ymult),0.0,1.0);
	return noise;
}

vec2 getVolumetricCloud(float pixeldepth, float pixeldepthw) {
	float h = 128.0;
	float t = 16.0;
	float s = 1.0;
	
	vec2 vc = vec2(0.0);
	float slength = 8.0;
	float dither = dither8x8(texcoord.xy)*slength;

	float maxDist = 2.0*far;
	float minDist = 0.01f+dither;
	vec4 wpos = vec4(0.0);

	for (minDist; minDist < maxDist; ) {
		if (getDepth(pixeldepth) < minDist || vc.y > 0.999){
			break;
		}
		wpos = getWorldPos(getFragPos(texcoord.xy,distx(minDist)));
		if (length(wpos.xz) < maxDist && getDepth(pixeldepthw) > minDist){
			float vh = hnoise((wpos.xz+cameraPosition.xz+frametime)*0.005);
			#ifdef WorldCurvature
			if (length(wpos.xz)<WorldCurvatureSize) wpos.y += length(wpos.xz)*length(wpos.xyz)/WorldCurvatureSize;
			else break;
			#endif
			wpos.xyz += cameraPosition.xyz + vec3(frametime*4.0,-vh*32.0,0.0);
			float noise = getVCSample(wpos.xyz,h,t,s);
			float col = pow(smoothstep(h-t*noise,h+t*noise,wpos.y),1.5);
			vc.x = max(noise*col,vc.x);
			vc.y = max(noise,vc.y);
		}
		minDist = minDist + slength;
	}
	return vc;
}

void main() {
	
	
	vec3 color = rangeExpand(texture2D(colortex0, texcoord.st).rgb);
	vec3 rawcolorb = vec3(0.0);
	vec3 landaux = texture2D(colortex4, texcoord.st).rgb;
	vec3 aux = texture2D(colortex5, texcoord.st).rgb;
	float ao = 1.0;
	float spec = texture2D(colortex0, texcoord.st).a;
	vec3 gr = vec3(0.0);
	vec2 vc = vec2(0.0);
	
	#ifdef LightmapBanding
	aux = vec3(floor(aux.r*16.0)/16.0,aux.g,floor(aux.b*16.0)/16.0);
	#endif
	
	vec3 light = calcLightColor(light_m, light_d + vec3(0.0, 0.25, 1.0), light_n, light_r);
	vec3 ambient = calcLightColor(sky_m, sky_d, sky_n, sky_r);
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float torchmap = pow(aux.b,2.2)*0.2 + pow(max(pow(aux.b,2.2)-0.5,0.0)*2.0,5.0);
	float alpha = pow(texture2D(colortex1,texcoord.xy).a,2.2);
	
	float translucent = float(matflag > 0.05);
	float water = float(matflag > 0.08 && matflag < 0.12);
	float particle = float(matflag > 0.18 && matflag < 0.22);
	float hand = float(matflag > 0.38 && matflag < 0.42);	
	
	float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (translucent > 0.9 && alpha > 0.0001) {
		vec3 colorb = pow(max(texture2D(colortex1, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2))/alpha;
		vec3 normal = texture2D(colortex3, texcoord.st).rgb*2.0-1.0;
		float specemissive = 0.0;
		
		#ifdef DisableTexture
			#ifdef ShadowColor
			colorb = mix(vec3(1.0)*mix(0.4,0.01,water),colorb,float(alpha < 0.98));
			#else
			colorb = vec3(1.0,1.0,1.0)*mix(0.4,0.01,water);
			#endif
		#endif
		
		#if LightShafts == 2
		rawcolorb = colorb;
		#endif
		
		vec4 worldpos = getWorldPos(fragpos);
		
		#ifdef WaterRefraction
		if (water > 0.9 && isEyeInWater < 0.9){
			vec2 newcoord = getRefract(texcoord.xy,worldpos.xyz+cameraPosition.xyz);
			color = rangeExpand(texture2D(colortex0, newcoord).rgb);
		}
		#endif
		
		#if Clouds == 2
		vec2 vc = vec2(texture2DLod(colortex4,texcoord.xy,float(2.0)).a,texture2DLod(colortex5,texcoord.xy,float(2.0)).a);
		float vcmult = 0.5*(1.0-moonVisibility*0.7)*(1.0-rainStrength*0.5);
		color = mix(color,mix(ambient*(1.0-mix(0.25,0.825,moonVisibility)*rainStrength),light*(1.0+mix(1.0,-0.75,moonVisibility)*rainStrength),vc.x)*vcmult,vc.y*vc.y);
		#endif
		
		color *= mix(vec3(1.0),colorb,pow(alpha,mix(1.0/2.2,1.0,water)));
		
		#ifdef EmissiveRecolor
		if (handRecolor > 0.9 && hand > 0.9){
			float ec = pow(length(colorb),2.8)*4.0;
			colorb = ec*pow(torch_c,vec3(2.2))*0.4+ec*0.35;
			}
		#endif
		
		vec3 finallight = vec3(0);
		vec3 scenelight = vec3(0);
		vec3 inambient = vec3(0.8)*pow(skymap,0.5)*(0.5+0.5*tB)*(1.0-eBS)*(1.0-rainStrength*0.8)*(0.025+0.975*sunVisibility);
		vec3 torchlight = pow(torch_c,vec3(1.2-0.2*pow(aux.b,0.25)))*torchmap*8.0*mix(1.0,pow(1.0/length(colorb),0.5),water);
		
		#ifdef RPSupport
		#if RPSFormat == 2
		specemissive = pow(texture2D(colortex6,texcoord.xy).b,0.5);
		torchlight += colorb*8.0*specemissive;
		#endif
		#endif
		
		float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
		vec3 uw_tint = mix(vec3(1.0),pow(water_c,vec3((1.0-skymap)*2.0))*skymap,absorb);
		
		float NdotL = max(dot(normal, lightVector)*1.05-0.05,0.0);
		float NdotU = pow(dot(normal, upVec)*0.25+0.75,2.2);
		if (particle > 0.9) NdotU = 2.0;
		float shading = getShadows(shadowtex0, worldpos, NdotL, 0.0);
		shading *= max(NdotL*nolight*(1.0-hand*handRecolor*0.8),0.0);
		
		vec3 shadowcol = vec3(0.0);
		#ifdef ShadowColor
		if (shading < 0.999) shadowcol = getShadowsColor(worldpos, NdotL, 0.0)*getShadows(shadowtex1, worldpos, NdotL, 0.0)*NdotL;
		#endif
		
		#ifdef ShadowLeakFix
		float shadowfix = clamp(skymap*20.0-1.0,eBS,1.0);
		shading *= shadowfix;
		shadowcol *= shadowfix;
		#endif
		
		#if TranslucentAO == 1 || TranslucentAO == 2
		#if TranslucentAO == 1
		float aoalpha = 0.98;
		#endif
		#if TranslucentAO == 2
		float aoalpha = 0.01;
		#endif
		
		if (alpha > aoalpha){
			#if AO == 1
			ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
			#if AO == 2
			if (hand < 0.9) ao = dbaoh(depthtex0);
			if (hand > 0.9) ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
			#if AO == 3
			if (hand < 0.9) ao = ssao(depthtex0,normal);
			if (hand > 0.9) ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
		}
		#endif
		
		float minlight = 1.0/255.0 * (4.0-3.0*eBS);
		float exposure = mix(3.0+2.0*shading*(1.0-0.75*rainStrength),1.0,eBS);
		float lightmult = calcLightIntensity(StrLDay,StrLNight,StrLRain);
		float skymult = calcLightIntensity(StrSDay,StrSNight,StrSRain);
		scenelight = mix(((ambient+inambient)*skymult*skymap+minlight)*ao,light*lightmult*(0.5+0.5*ao),max(vec3(shading),shadowcol)*(1.0-0.9*rainStrength))*exposure;
		finallight = (scenelight*uw_tint+torchlight*ao)*NdotU+nightVision;
		
		colorb = colorb/sqrt(1.0+colorb*colorb);
		colorb *= finallight;
		
		#ifdef Desaturation
		float ddesat = clamp(max(pow(shading,0.2),skymap)*sunVisibility*(1-rainStrength*0.8)+aux.b*1.25+specemissive,0.15+0.05*skymap*(1.0-rainStrength),1.0);
		vec3 desat_c = mix(vec3(length(light_n))*sky_r,light_n,skymap*(1.0-rainStrength))*4.0;
		colorb = mix(luma(colorb)*desat_c,colorb,ddesat);
		#endif
		
		color = mix(color,colorb,alpha);
		
		#ifdef Fog
		if (isEyeInWater < 0.9) color = calcFog(color, light, fragpos.xyz);
		#endif
		
		if (water > 0.9) spec = Blinn_Phong(fragpos.xyz,lightVector,normal,12.0+moonVisibility,shading);
		
		#ifdef RPSupport
		float smoothness = texture2D(colortex6,texcoord.xy).r;
		if (water < 0.9){
			spec = Blinn_Phong(fragpos.xyz,lightVector,normal,1.0+(11.0+moonVisibility)*smoothness,shading);
			spec = spec/(1.0+spec);
			}
		#endif
	}
	
	#if LightShafts == 1
	if (isEyeInWater < 0.9){
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		tpos.xy = tpos.xy/tpos.z;
		vec2 lightPos = tpos.xy*0.5+0.5;
		float truepos = sunPosition.z/abs(sunPosition.z);
		
		vec2 deltacoord = texcoord.xy-lightPos;
		vec2 grcoord = texcoord.xy + deltacoord*0.1;
		
		float grfade = pow(max(1.0-length(deltacoord*vec2(1.0,1.0/aspectRatio))*2.0,0.0),2.2);
		float centerdist = 0.25 + 0.75*pow(max(1.0-length(tpos.xy*vec2(aspectRatio,1.0)*0.5),0.0),1.5);
		float grw = 0.0;
		
		if (grfade > 0.001 && (truepos < 0.0 && sunVisibility > 0.001 || truepos > 0.0 && moonVisibility > 0.001)){
			for (int i = 0; i < 3; i++) {
			float samplea = texture2DLod(colortex4,getGRCoord(grcoord,deltacoord,0.25),float(0.0)).g;
			vec4 sampleb = texture2D(colortex1,getGRCoord(grcoord,deltacoord,0.25));
			gr += float(samplea < 0.02)*mix(vec3(1.0),vec3(sampleb.rgb)*4.0,pow(sampleb.a,0.2))*(1.0-sampleb.a)*centerdist;
			grcoord -= deltacoord*0.25;
			}
		}
		
		gr /= 3.0;
	}
	#endif
	
	#if LightShafts == 2
	gr = getVolumetricRays(texture2D(depthtex1,texcoord.xy).x,rawcolorb,alpha,water)*nolight;
	#endif
	
	#if Clouds == 2
	float pixeldepthl = texture2D(depthtex1,texcoord.xy).x;
	vc = getVolumetricCloud(pixeldepthl,pixeldepth);
	#endif
	
/* DRAWBUFFERS:0145 */
	
	gl_FragData[0] = vec4(rangeCompress(color),spec);
	gl_FragData[1] = vec4(pow(gr,vec3(1.0/2.2)),0.0);
	gl_FragData[2] = vec4(landaux,vc.x);
	gl_FragData[3] = vec4(aux,vc.y);

}
