#version 120

//#define WorldCurvature
#define WorldCurvatureSize 1024		// [32 64 128 256 512 1024 2048 4096 8192]

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

#ifdef WorldCurvature
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
#endif

void main() {
	
	texcoord = (gl_MultiTexCoord0);
	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	
	#ifdef WorldCurvature
	vec4 position = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	position.y -= (length(position.xz)*length(position.xz))/WorldCurvatureSize;
	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;
	#else
	gl_Position = ftransform();
	#endif
	
	color = gl_Color;
	
	normal = normalize(gl_NormalMatrix * gl_Normal);
}