#version 120

//#define RPSupport

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;
#ifdef RPSupport
uniform sampler2D specular;
#endif
uniform vec4 entityColor;

void main() {	
	
	vec2 adjustedTexCoord = texcoord.st;
	vec4 albedo = texture2D(texture,adjustedTexCoord)*color;
	vec4 mobColor = entityColor;
	mobColor.rgb = pow(mobColor.rgb,vec3(2.2));
	albedo.rgb = mix(albedo.rgb,mobColor.rgb,mobColor.a);
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	vec4 spec = vec4(0.0);
	#ifdef RPSupport
	spec = texture2D(specular,adjustedTexCoord);
	#endif
	
/* DRAWBUFFERS:0246 */
	
	gl_FragData[0] = vec4(albedo);
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, mix(1.0,0.5,float(mobColor.a > 0.05)), lmcoord.s, 1.0);
	gl_FragData[3] = spec;
}