#version 120
#extension GL_ARB_shader_texture_lod : enable

#define EmissiveRecolor
//#define RPSupport

#define NORMAL_MAP_MAX_ANGLE 1.0
#define POM_MAP_RES 128.0 //[16.0 32.0 64.0 128.0 256.0 512.0 1024.0 2048.0]
#define POM_DEPTH 0.1 //[0.1 0.2 0.3 0.4 0.5]

/* Here, intervalMult might need to be tweaked per texture pack.  
   The first two numbers determine how many samples are taken per fragment.  They should always be the equal to eachother.
   The third number divided by one of the first two numbers is inversely proportional to the range of the height-map. */
const vec3 intervalMult = vec3(1.0, 1.0, 1.0/POM_DEPTH)/POM_MAP_RES * 1.0; 

const float MAX_OCCLUSION_DISTANCE = 96.0;
const float MIX_OCCLUSION_DISTANCE = 64.0;
const int   MAX_OCCLUSION_POINTS   = int(POM_MAP_RES);


const int RGBA16 = 4;
const int RGB16 = 3;
const int RGBA8 = 2;
const int RGB8 = 1;
const int R8 = 0;

const int colortex0Format = RGBA16;
const int colortex1Format = RGBA16;
const int colortex2Format = RGB16;
const int colortex3Format = RGB16;
const int colortex4Format = RGBA8;
const int colortex5Format = RGBA8;
const int colortex7Format = RGBA8;

const float bump_distance = 64.0;		//bump render distance: tiny = 32, short = 64, normal = 128, far = 256
const float pom_distance = 32.0;		//POM render distance: tiny = 32, short = 64, normal = 128, far = 256
const float fademult = 0.1;

varying vec2 lmcoord;
varying vec4 color;
varying vec2 texcoord;
varying float mat;
varying float recolor;
varying float brmult;
uniform float rainStrength;

varying vec3 normal;

uniform sampler2D texture;

#ifdef RPSupport
const int colortex6Format = RGBA8;

uniform sampler2D specular;
uniform sampler2D normals;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;
varying vec3 wpos;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 viewVector;
varying float dist;

varying vec2 speculartest;

vec2 dcdx = dFdx(texcoord.xy);
vec2 dcdy = dFdy(texcoord.xy);

vec4 readTexture(in vec2 coord)
{
	return texture2DGradARB(texture,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

vec4 readNormal(in vec2 coord)
{
	return texture2DGradARB(normals,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

const float mincoord = 1.0/4096.0;
const float maxcoord = 1.0-mincoord;
#endif

#include "lib/torchColor.glsl"

void main() {
	vec4 albedo = texture2D(texture, texcoord);
	
	#ifdef RPSupport
	vec2 adjustedTexCoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;
	if (dist < MAX_OCCLUSION_DISTANCE) {
			if ( viewVector.z < 0.0 && readNormal(vtexcoord.st).a < 0.99 && readNormal(vtexcoord.st).a > 0.01){
				vec3 interval = viewVector.xyz * intervalMult / dist;
				vec3 coord = vec3(vtexcoord.st, 1.0);
					for (int loopCount = 0; (loopCount < MAX_OCCLUSION_POINTS) && (readNormal(coord.st).a < coord.p); ++loopCount) {
						coord = coord+interval;
					}
				if (coord.t < mincoord) {
					if (readTexture(vec2(coord.s,mincoord)).a == 0.0) {
						coord.t = mincoord;
						discard;
					}
				}
			adjustedTexCoord = mix(fract(coord.st)*vtexcoordam.pq+vtexcoordam.st , adjustedTexCoord , clamp((dist-MIX_OCCLUSION_DISTANCE)/(MAX_OCCLUSION_DISTANCE-MIX_OCCLUSION_DISTANCE),0.0,1.0));
		}
	}
	albedo = texture2DGradARB(texture, adjustedTexCoord, dcdx, dcdy);
	#endif
	
	vec4 frag2 = vec4(normal*0.5+.5, 1.0f);
	vec4 spec = vec4(0.0);
	
	albedo.rgb *= 1.0+brmult;
	
	#ifdef EmissiveRecolor
	if(recolor > 0.9){
		float ec = clamp(pow(length(albedo.rgb),1.4),0,2.2);
		albedo.rgb = clamp(ec*torch_c*0.4+ec*0.35,vec3(0),vec3(2.2));
	}
	if(mat > 0.18 && mat < 0.22){
		float ec = clamp(pow(length(albedo.rgb),1.4),0,2.2);
		albedo.rgb = clamp(ec*vec3(0.6, 0.35, 0.085)+ec*0.1,vec3(0),vec3(2.2));
	}
	#endif
	
	#ifdef RPSupport
	vec3 bump = texture2DGradARB(normals, adjustedTexCoord, dcdx, dcdy).rgb*2.0-1.0;
	float bumpmult = NORMAL_MAP_MAX_ANGLE*(1.0-rainStrength*lmcoord.t*0.9);
	bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
	mat3 tbnMatrix = mat3(  tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);

	frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	spec = texture2DGradARB(specular, adjustedTexCoord, dcdx, dcdy);
	#endif
	
/* DRAWBUFFERS:01246 */

	gl_FragData[0] = albedo*color;
	gl_FragData[1] = vec4(0.0,0.0,0.0,0.0);
	gl_FragData[2] = frag2;	
	gl_FragData[3] = vec4(lmcoord.t, mat, lmcoord.s, 1.0);
	gl_FragData[4] = spec;
}