#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;
uniform float rainStrength;

void main() {
	vec2 adjustedTexCoord = texcoord.st;
	vec3 albedo = texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	
/* DRAWBUFFERS:7 */

	gl_FragData[0] = vec4(albedo,(texture2D(texture,adjustedTexCoord).a));
}