#define Clouds 1 //[0 1 2]

#if Clouds == 1
vec3 drawCloud(vec3 fposition,vec3 color, vec3 light, vec3 ambient) {
float totalcloud = 0;
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float cosS = dot(sunVec,sVector);
float pi = 3.1415927;
float dither = dither8x8(texcoord.xy);
vec2 wind = vec2(frametime,0.0)*0.001;

vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wVector = normalize(tpos);

float cloud = 0.0;
float cloudalpha = 0.0;
vec3 cloud_color = vec3(0.0);
float colmix = 0.0;
float colmult = 0.5*(1.0-moonVisibility*0.7)*(1.0-wetness*(0.9-0.5*sunVisibility));

if (cosT > 0.0){
	for (int i = 0; i < 4; i++) {
		vec3 intersection = wVector*((16.0+(i+dither))/wVector.y);
		vec2 coord = (intersection.xz + cameraPosition.xz*0.125)*0.002;
		
		float noise = 0.0;
		if (cloud < 0.999){
			noise+= texture2D(noisetex,coord*0.5+wind*0.5).x;
			noise+= texture2D(noisetex,coord*0.25+wind*0.4).x*2;
			noise+= texture2D(noisetex,coord*0.125+wind*0.3).x*3;
			noise+= texture2D(noisetex,coord*0.0625+wind*0.2).x*4;
			noise+= texture2D(noisetex,coord*0.03125+wind*0.1).x*5;
			noise+= texture2D(noisetex,coord*0.016125).x*6;
			noise = clamp(mix(noise,21.0,0.15*wetness)-(10.0+abs(float(i-2+dither))),0.0,1.0);
			}
		float hnoise = texture2D(noisetex,coord*0.25+wind*0.4).x;
		cloud_color = mix(cloud_color,mix(ambient*(1.0-0.2*wetness)*(1.0-0.5*moonVisibility),light,pow(colmix+0.25*(hnoise*hnoise*(0.7*wetness+0.7)+dither),2.0)),noise*(1.0-cloud*cloud));
		cloud = max(cloud,noise);
		colmix += 0.25;
		cloudalpha += cloud;
	}
	cloudalpha *= 0.25;
	cloud_color *= (1.0+2.0*(1.0-cloudalpha)*pow(max(cosS,0.0),8.0)*wetness)*(2.0-eBS)*(1.0+nightVision);
	cloud *= clamp(cosT*10.0-0.5,0.0,1.0);
}
return mix(color,cloud_color*colmult,cloud*cloud);
}
#endif