#define FogRange 8 //[2 4 6 8 10 12 14 16 20 24 28 32]
#define SkyColor 0 //[0 1 2 3 4]
//0 Original || 1 Vanilla || 2 Vanila Alternative || 3 Alternative || 4 Classic

#if SkyColor == 0
vec3 sky_c = vec3(0.15, 0.38, 1.00);
vec3 fog_c = vec3(0.15, 0.38, 1.00);
#endif

#if SkyColor == 1
uniform vec3 skyColor;
uniform vec3 fogColor;

vec3 sky_c = pow(skyColor,vec3(2.2));
vec3 fog_c = pow(fogColor,vec3(2.2));
#endif

#if SkyColor == 2
uniform vec3 skyColor;
uniform vec3 fogColor;

vec3 sky_c = pow(skyColor,vec3(3.0));
vec3 fog_c = pow(fogColor,vec3(3.0));
#endif

#if SkyColor == 3
vec3 sky_c = vec3(0.25, 0.4, 1.0);
vec3 fog_c = vec3(0.25, 0.4, 1.0);
#endif

#if SkyColor == 4
vec3 sky_c = vec3(0.1, 0.35, 1.0);
vec3 fog_c = vec3(0.1, 0.35, 1.0);
#endif

vec3 getSkyColor(vec3 fragpos, vec3 light){
vec3 sky_col = sky_c;
vec3 nfragpos = normalize(fragpos);

float NdotUp = dot(nfragpos,upVec);
float NdotS = dot(nfragpos,sunVec);

float top = pow(max(NdotUp,0.1),0.25)*0.48;
float horizon = pow(max(0.9-abs(NdotUp),0.0)*1.05,2.5)*(0.2+0.6*sunVisibility)*(1-rainStrength*0.5);
float lightmix = (pow(max(NdotS,0.0),1.5)*(1-max(NdotUp,0.0))*pow(1.0-tB,3.0) + horizon*0.1*tB)*sunVisibility*(1.0-rainStrength);

#if SkyColor == 1 || SkyColor == 5
sky_col = mix(sky_col,fog_c,pow(max(0.8-abs(NdotUp),0.0)*1.25,0.5));
top *= 0.99;
#endif

#if SkyColor == 2
sky_col = mix(sky_col,fog_c,max(0.75-abs(NdotUp),0.0)*1.33);
top *= 0.7;
horizon *= 0.8;
#endif

float mult = 0.5 - top*(1.0-rainStrength*rainStrength*0.4) + horizon;

sky_col = (mix(sky_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4);
sky_col = mix(sky_col,pow(mult,0.2)*sky_r*(0.05+0.65*sunVisibility),rainStrength)*mult*(3.0-2.0*eBS);

#if SkyColor == 2
sky_col = sky_col/sqrt(1.0+sky_col*sky_col);
#endif

return pow(sky_col,vec3(1.15));
}

vec3 getFogColor(vec3 fragpos, vec3 light){
vec3 fog_col = fog_c;
vec3 nfragpos = normalize(fragpos);

float NdotUp = dot(nfragpos,upVec);
float NdotS = dot(nfragpos,sunVec);

float top = pow(max(NdotUp*0.5+0.5,0.0),2.0)*0.25;
float lightmix = pow(max(NdotS,0.0),1.5)*pow(1.0-tB,3.0)*sunVisibility*(1.0-rainStrength);
float mult = 0.5 - top;

fog_col = (mix(fog_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4)*1.2;
fog_col = mix(fog_col,pow(mult,0.2)*sky_r*(0.04+0.52*sunVisibility),rainStrength)*mult;

return pow(fog_col,vec3(1.15));
}

vec3 calcFog(vec3 color, vec3 light, vec3 fragpos){
float fog = length(fragpos)/(FogRange*(64.0-48.0*rainStrength)*(1.0+sunVisibility));
return mix(color,getFogColor(fragpos,light),min(fog,1.0)*eBS);
}

vec3 calcWFog(vec3 color, vec3 wcol, float wstr, float fogrange, float nofog, vec3 fragpos){
float fog = min(length(fragpos)/(fogrange*(1.0+3.0*eBS)),1.0);
return mix(color,pow(wcol*pow(wstr,0.75),vec3(2.2)),min(fog,1.0)*max(1.0-nofog,0.0));
}

vec3 calcBFog(vec3 color, float blindness, vec3 fragpos){
	float b = max(blindness*2.0-1.0,0.0);
	b = b*b;
	float fog = pow(min(length(fragpos)/(5.0/b),1.0),1.0/2.2)*b;
	return mix(color,vec3(0.0),fog);
}

vec3 calcLFog(vec3 color, vec3 fragpos){
	float fog = min(length(fragpos)/(2.0),1.0);
	return mix(color,vec3(1.0,0.3,0.01),fog);
}