#define ShadowFilter 1 //[0 1 2]
#define ShadowFilterSize 1.00 //[0.25 0.50 0.75 1.00 2.00 3.00 4.00]
#define ShadowCloseDithering
#define ShadowOffset 0.10 //[0.05 0.10 0.15 0.20 0.25 0.30]

#if ShadowFilter == 2
vec2 hqoffset[24] = vec2[24](vec2(0.33,0.0),
							 vec2(0.0,0.33),
							 vec2(-0.33,0.0),
							 vec2(0.0,-0.33),
							 vec2(0.66,0.0),
							 vec2(0.46,0.46),
							 vec2(0.0,0.66),
							 vec2(-0.46,0.46),
							 vec2(-0.66,0.0),
							 vec2(-0.46,-0.46),
							 vec2(0.0,-0.66),
							 vec2(0.46,-0.46),
							 vec2(1.0,0.0),
							 vec2(0.86,0.5),
							 vec2(0.5,0.86),
							 vec2(0.0,1.0),
							 vec2(-0.5,0.86),
							 vec2(-0.86,0.5),
							 vec2(-1.0,0.0),
							 vec2(-0.86,-0.5),
							 vec2(-0.5,-0.86),
							 vec2(0.0,-1.0),
							 vec2(0.5,-0.86),
							 vec2(0.86,-0.5));
#endif

float getShadows(sampler2DShadow tex, vec4 worldPos, float NdotL, float foliage){

	float shading = 1.0;

	vec4 shadowpos = getShadowPos(worldPos);
	
	float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
	float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
	float distmult = shadowDistance/256.0;
	
	float diffthresh = (pow(distortFactor,2.0)*(4.0/shadowMapResolution)*(tan(acos(abs(NdotL)))) + (ShadowOffset/shadowMapResolution))*distmult;
	shadowpos = distortShadow(shadowpos,distortFactor);
	float step = ShadowFilterSize*0.00048828125;
	
	#ifdef ShadowCloseDithering
	shadowpos.z -= 0.0625*dither8x8(texcoord.xy)/shadowMapResolution;
	#endif
	
	if (foliage > 0.9){
		diffthresh = 0.0002;
		step = 0.0009765625;
		}
	
	if (NdotL > 0.0 || foliage > 0.9){
		#if ShadowFilter == 2
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		for (int i = 0; i < 24; ++i){
			shading += shadow2D(tex,vec3(shadowpos.st+hqoffset[i]*step, shadowpos.z-diffthresh*(1.0+shadowMapResolution*ShadowFilterSize*0.125*step))).x;
		}
		shading *= 0.04;
		#endif
		#if ShadowFilter == 1
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).x;
		shading *= 0.2;
		#endif
		#if ShadowFilter == 0
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		#endif
	}else{
		shading = 0.0;
	}
	
	return shading;
}

#ifdef ShadowColor
vec3 getShadowsColor(vec4 worldPos, float NdotL, float foliage){

	vec3 shading = vec3(1.0);

	vec4 shadowpos = getShadowPos(worldPos);
	
	float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	float distmult = shadowDistance/256.0;
	
	float diffthresh = (pow(distortFactor,2.0)*(4.0/shadowMapResolution)*(tan(acos(abs(NdotL)))) + (ShadowOffset/shadowMapResolution))*distmult;
	shadowpos = distortShadow(shadowpos,distortFactor);
	float step = ShadowFilterSize*0.00048828125;
	
	#ifdef ShadowCloseDithering
	shadowpos.z -= 0.0625*dither8x8(texcoord.xy)/shadowMapResolution;
	#endif
	
	if (foliage > 0.9){
		diffthresh = 0.0002;
		step = 0.0009765625;
		}
	
	if (NdotL > 0.0 || foliage > 0.9){
		#if ShadowFilter == 2
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		for (int i = 0; i < 24; ++i){
			shading += shadow2D(shadowcolor,vec3(shadowpos.st+hqoffset[i]*step, shadowpos.z-diffthresh*(1.0+shadowMapResolution*ShadowFilterSize*0.125*step))).rgb;
		}
		shading *= 0.04;
		#endif
		#if ShadowFilter == 1
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).rgb;
		shading *= 0.2;
		#endif
		#if ShadowFilter == 0
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		#endif
	}
	
	return shading*4.0*NdotL;
}
#endif