#version 120

//#define ShadowColor
#define WaterCaustic 0 //[0 1 2]
//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

varying vec4 texcoord;
varying float checkalpha;
varying float disablecolor;

uniform sampler2D tex;
uniform int worldTime;
uniform float frameTimeCounter;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

#if WaterCaustic == 2 && defined ShadowColor
varying vec3 wpos;
varying float water;
uniform sampler2D noisetex;

float waterH(vec3 pos) {
float noise = 0;

noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

return pow(clamp((noise+0.8)/3.0,0.0,1.0),2.2);
}
#endif

void main() {
	vec4 albedo = texture2D(tex,texcoord.xy);
	
	#ifdef ShadowColor
	//albedo.a = fract(wpos.x*0.5-0.5);
	albedo.rgb = mix(vec3(1),albedo.rgb,pow(albedo.a,(1.0-albedo.a)*0.5)*1.05);
	albedo.rgb *= 1.0-pow(albedo.a,16.0);
	//if ((checkalpha > 0.9 && albedo.a > 0.98) || checkalpha < 0.9) albedo.rgb *= 0.0;
	#else
	if (checkalpha > 0.9 && albedo.a < 0.98) albedo.a*= 0.0;
	#endif
	
	#if WaterCaustic == 2 && defined ShadowColor
	if (water > 0.9){
		float deltaPos = 0.1;
		float h0 = waterH(wpos);
		float h1 = waterH(wpos + vec3(deltaPos,0.0,0.0));
		float h2 = waterH(wpos + vec3(-deltaPos,0.0,0.0));
		float h3 = waterH(wpos + vec3(0.0,0.0,deltaPos));
		float h4 = waterH(wpos + vec3(0.0,0.0,-deltaPos));
		
		float caustic = max((1.0-abs(0.5-h0))*(1.0-(abs(h1-h2)+abs(h3-h4))),0.0);
		caustic = clamp(max(pow(caustic,3.5),0.0),0.0,1.0);
		
		albedo.rgb = vec3(1.0+3.0*caustic);
		}
	#endif
	
	if (disablecolor > 0.9) albedo.a *= 0.0;
	
	gl_FragData[0] = vec4(albedo.rgb*0.25,albedo.a);
	
}