#version 120

#define AO 2 //[0 1 2 3]
#define BrightEmissive
//#define BumpyEdge
//#define Celshade
#define Desaturation
//#define DisableTexture
#define Fog
//#define LightmapBanding
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
//#define ShadowColor
#define Stars
#define WaterCaustic 0 //[0 1 2]
#define WaterFog
//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

#define StrSNether 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTNormal 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTBright 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

const float sunPathRotation = -40.0;
const float eyeBrightnessHalflife = 10.0f;
const int noiseTextureResolution  = 1024;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform float blindness;
uniform float nightVision;
uniform int worldTime;
uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform float far;
uniform float near;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float getSSS(vec3 normal, vec3 lightVector, vec3 fragpos){
	return max(dot(-normal,lightVector),0.0)*pow(max(dot(normalize(fragpos),normalize(lightVector)),0.0),25.0)*(1.0-rainStrength);
}

float edepth(sampler2D depth, vec2 coord) {
	return texture2D(depth,coord).r;
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither8x8(vec2 pos)
{
	const int ditherPattern[64] = int[64](
		0, 32, 8, 40, 2, 34, 10, 42,
		48, 16, 56, 24, 50, 18, 58, 26,
		12, 44, 4, 36, 14, 46, 6, 38,
		60, 28, 52, 20, 62, 30, 54, 22,
		3, 35, 11, 43, 1, 33, 9, 41,
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

    vec2 positon = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 8.0f));

	int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

	return float(dither) / 64.0f;
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal, float gloss, float visibility)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);	
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 8.0).r*0.2;

	return noise;
	}

float getCaustic(vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float caustic = max((1.0-abs(0.5-h0))*(1.0-(abs(h1-h2)+abs(h3-h4))),0.0);
		  caustic = max(pow(caustic,3.5),0.0)*2.0;
		  
	return caustic;
}

#include "lib/colorRange.glsl"
#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/celShading.glsl"
#include "lib/ambientOcclusion.glsl"

void main() {
	
	vec3 color = pow(max(texture2D(colortex0, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2));
	vec3 aux = texture2D(colortex4, texcoord.st).rgb;
	float ao = 1.0;
	float spec = 0.0;
	
	#ifdef LightmapBanding
	aux = vec3(floor(aux.r*16.0)/16.0,aux.g,floor(aux.b*16.0)/16.0);
	#endif
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float wmatflag = texture2D(colortex5, texcoord.st).g;
	float torchmap = pow(aux.b,2.2)*0.2*StrTNormal + pow(max(pow(aux.b,2.2)-0.5,0.0)*2.0,5.0)*StrTBright;
	
	float land = float(matflag > 0.05);
	float lava = float(matflag > 0.18 && matflag < 0.22);
	float metal = 0.0;
	float foliage = float(matflag > 0.38 && matflag < 0.42);
	float emissive = float(matflag > 0.48 && matflag < 0.52);
	
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	float translucent = float(wmatflag > 0.05);
	float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
	
	float pixeldepth = texture2D(depthtex1,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (land > 0.9) {
		vec3 normal = texture2D(colortex2, texcoord.st).rgb*2.0-1.0;
		float specemissive = 0.0;
		
		#ifdef DisableTexture
		color = vec3(1.0,1.0,1.0)*0.4*(1.0+0.5*(emissive+lava));
		#endif
		
		vec4 worldpos = getWorldPos(fragpos);
		
		vec3 finallight = vec3(0);
		vec3 scenelight = vec3(0);
		vec3 torchlight = pow(torch_c,vec3(1.2-0.2*pow(aux.b,0.25)))*torchmap*8.0;
		
		#ifdef RPSupport
		#if RPSFormat == 0
		metal = float(matflag > 0.28 && matflag < 0.32);
		#endif
		#if RPSFormat == 1
		metal = texture2D(colortex6,texcoord.xy).g;
		#endif
		#if RPSFormat == 2
		metal = texture2D(colortex6,texcoord.xy).g;
		specemissive = pow(texture2D(colortex6,texcoord.xy).b,0.5);
		torchlight += color*8.0*specemissive;
		emissive *= 0.0;
		#endif
		#endif
		
		#ifdef BrightEmissive
		vec3 emissivelight = color*(emissive+lava*2.0)*8.0;
		#else
		vec3 emissivelight = vec3(0.0);
		#endif
		
		float NdotU = pow(dot(normal, upVec)*0.25+0.75,2.2);
		
		vec3 uw_tint = mix(vec3(1.0),water_c*0.5,absorb)*(1.0+water);
		
		#if WaterCaustic == 1 || WaterCaustic == 2
		if (absorb > 0.9){
		vec3 causticpos = worldpos.xyz+cameraPosition.xyz;
		float caustic = getCaustic(causticpos);
		vec3 torchcaustic = caustic*2.0*pow(torch_c,vec3(0.5/2.2))*pow(aux.b,2.2);
		color *= 1.0+torchcaustic;
		}
		#endif
		
		if (foliage > 0.9) NdotU *= 1.8;
		
		#if AO == 1
		if (lava < 0.9 && water < 0.9) ao = dbaol(ao,depthtex1,fragpos.xyz);
		#endif
		#if AO == 2
		ao = dbaoh(depthtex1);
		#endif
		#if AO == 3
		ao = ssao(depthtex1,normal);
		#endif
		
		scenelight = vec3(0.05)*ao*StrSNether;
		finallight = (scenelight*uw_tint+torchlight*ao+nightVision)*NdotU+emissivelight;
		
		color = color/sqrt(1.0+color*color);
		color *= finallight;
		
		#ifdef Desaturation
		float desat = clamp(aux.b*1.25+emissive+lava+specemissive,0.2,1.0);
		color = mix(luma(color)*desat_c,color,desat);
		#endif
		
		#ifdef Fog
		if (absorb < 0.9) color = calcFog(color, fragpos.xyz);
		#endif
	}
	else{
	color = fog_c;
	}
	
	#ifdef WaterFog
	if (absorb > 0.9 || (isEyeInWater > 0.9 && (translucent > 0.9 || land < 0.9) && water < 0.9)){
		float cosT = dot(normalize(fragpos.xyz),normalize(upVec));
		float wnofog = max(mix(clamp(cosT*32.0+1.5,0.0,1.0), skymap/mix(1.0,max(length(fragpos.xyz),1.0),isEyeInWater), land)-(1.0-eBS),0.0);
		vec3 wfog_c = water_c;
		color = calcWFog(color, wfog_c, cmult, wfogrange, wnofog, fragpos.xyz);
	}
	#endif
	
	if (wmatflag > 0.05){
		#ifdef Celshade
		color *= celshade(depthtex1,length(fragpos.xyz));
		#endif
		
		#ifdef BumpyEdge
		color = bumpyedge(color,depthtex1);
		#endif
		
		#ifdef Fog
		if (isEyeInWater > 1.9) color = calcLFog(color,fragpos.xyz);
		if (blindness > 0.001) color = calcBFog(color,blindness,fragpos.xyz);
		#endif
	}
	
/* DRAWBUFFERS:0 */
	
	gl_FragData[0] = vec4(rangeCompress(color),spec);

}
