#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;

void main() {
	vec2 adjustedTexCoord = texcoord.st;
	vec4 albedo = texture2D(texture,adjustedTexCoord)*color;
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	
	float matflag = 1.0;
	if (albedo.a > 0.38 && albedo.a < 0.42) matflag = 0.5;
	
/* DRAWBUFFERS:1356 */

	gl_FragData[0] = vec4(albedo.rgb,1.0);
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, matflag, lmcoord.s, 1.0);
	gl_FragData[3] = vec4(0.0,0.0,0.0,1.0);
}