float dbaol(float ao, sampler2D depth, vec3 fragpos){
	float total = 0.0;
	float d = texture2D(depth,texcoord.xy).r;
	float dtresh = 1/(far-near)/200.0;	
	vec4 dc = vec4(d,d,d,d);
	vec4 sa = vec4(0.0);
	vec4 sb = vec4(0.0);
	
	float dist = pow(1.0/length(fragpos),0.2);
	float noise = 0.7+0.6*dither8x8(texcoord.xy)*dist;
	float pw = 20.0/1280.0*noise;
	float ph = pw*aspectRatio;
	
	for(int i = 0; i < 2; i++){
		sa.x = texture2D(depth,texcoord.xy + vec2(-pw,-ph)*0.7*(1.0+i)).r;
		sa.y = texture2D(depth,texcoord.xy + vec2(pw,-ph)*0.7*(1.0+i)).r;
		sa.z = texture2D(depth,texcoord.xy + vec2(-pw,0.0)*(1.0+i)).r;
		sa.w = texture2D(depth,texcoord.xy + vec2(0.0,ph)*(1.0+i)).r;
		
		sb.x = texture2D(depth,texcoord.xy + vec2(pw,ph)*0.7*(1.0+i)).r;
		sb.y = texture2D(depth,texcoord.xy + vec2(-pw,ph)*0.7*(1.0+i)).r;
		sb.z = texture2D(depth,texcoord.xy + vec2(pw,0.0)*(1.0+i)).r;
		sb.w = texture2D(depth,texcoord.xy + vec2(0.0,-ph)*(1.0+i)).r;
		
		vec4 dd = (2.0* dc - sa - sb) - dtresh;
		dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
		float e = clamp(dot(dd,vec4(0.25)),0.0,1.0);
		total += e;
		dtresh = 1/(far-near)/(200.0+100*i);
	}
	total = mix(1.0,total*0.5,dist)*0.4+0.6;
	return ao*total;
}

float dbaoh(sampler2D depth){
	float ao = 0.0;
	
	int aoloop = 3;
	int aoside = 4;
	float d = ld(texture2D(depth,texcoord.xy).r);
	float piangle = 22.0/(7.0*180.0);
	float dither = dither8x8(texcoord.xy);
	float rot = 90.0+360.0/aoside*(dither-0.5);
	float scale = 1.4/aoloop*(0.5+dither);
	float sd = 0.0;
	float angle = 0.0;
	float dist = 0.0;
	
	for (int i = 0; i < aoloop; i++) {
		for (int j = 0; j < aoside; j++) {
			sd = ld(texture2D(depth,texcoord.xy+vec2(cos(rot*piangle),sin(rot*piangle))*scale/max(2.0*far*d,1.0)*vec2(1.0/aspectRatio,1.0)).r);
			angle += clamp(1.0-2.0*far*(d-sd),0.0,2.0);
			dist += clamp(0.25*far*(d-sd),0.0,1.0);
			rot += 360.0/aoside;
		}
		rot += 180.0/aoside;
		scale += 1.4/aoloop;
	}
	
	angle /= aoloop*aoside;
	dist /= aoloop*aoside;
	
	ao = clamp(angle,0.0,1.0)+clamp(dist,0.0,1.0);
	return clamp(ao,0.0,1.0);
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth){
vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
fragposition /= fragposition.w;
return fragposition.xyz;
}

float ssao(sampler2D depth, vec3 norm){
	float ao = 0.0;
	float pi = 22.0/7.0;
	float aopixeldepth = texture2D(depth,texcoord.xy).x;
	vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,aopixeldepth); 
	float dither = dither8x8(texcoord.xy);
	
	int aoloop = 4;
	int aoside = 6;
	float rprogress = 90.0+(360/aoside*(dither-0.5));
	float sprogress = 1.0;
	ao = 0.0;
	float aorad = 0.025;

	float aosize = 0.25/length(projpos);
	
	for (int i = 0; i < aoloop; i++) {
		for (int j = 0; j < aoside; j++) {
			vec2 samplecoord = vec2(cos(rprogress*pi/180),sin(rprogress*pi/180))*((sprogress+(dither-0.5)/aoloop)*aosize*vec2(1,aspectRatio)) + texcoord.xy;
			float sample = texture2D(depth,samplecoord).x;
			vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
			float angle = min(1.0-dot(norm,normalize(sprojpos-projpos)),1.0);
			float dist = min(abs(ld(sample)-ld(aopixeldepth)),aorad)/aorad;
			float temp = min(dist+angle,1.0);
			ao += temp;
			rprogress += 360/aoside;
		}
		sprogress = (1.0+i)/aoloop;
		rprogress += 180/aoside;
	}

	ao /= aoloop*aoside;
	return pow(ao,2.2);
}