float celshade(sampler2D depth,float poslength){
float pw = 1.0/1280.0;
float ph = pw*aspectRatio;

float outline = ld(texture2D(depth,texcoord.xy).r)*far*8.0;
outline-= ld(texture2D(depth,texcoord.xy+vec2(pw*2.0,0.0)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(-pw*2.0,0.0)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(0.0,ph*2.0)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(0.0,-ph*2.0)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(pw*1.4,ph*1.4)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(-pw*1.4,ph*1.4)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(pw*1.4,-ph*1.4)).r)*far;
outline-= ld(texture2D(depth,texcoord.xy+vec2(-pw*1.4,-ph*1.4)).r)*far;

//outline = -outline;

outline = mix(clamp(1.0-outline*0.5,0.0,1.0),1.0,clamp(poslength/512,0.0,1.0));

return outline;
}

float getdist(sampler2D depth, float rng) {
	return 1-clamp(ld(texture2D(depth,texcoord.xy).r)/rng*far,0,1);
}

vec3 bumpyedge(vec3 color, sampler2D depth) {
//edge detect
float pw = 1.0/1280.0;
float ph = pw*aspectRatio;
float d = edepth(depth,texcoord.xy);
float dtresh = 1/(far-near)/150.0;
vec4 dc = vec4(d,d,d,d);
vec4 sa;
vec4 sb;
float dist = ld(edepth(depth,texcoord.xy));
float bord = min(0.125 / dist,4.0);
sa.x = edepth(depth,texcoord.xy + vec2(-pw,-ph)*bord);
sa.y = edepth(depth,texcoord.xy + vec2(pw,-ph)*bord);
sa.z = edepth(depth,texcoord.xy + vec2(-pw,0.0)*bord);
sa.w = edepth(depth,texcoord.xy + vec2(0.0,ph)*bord);

//opposite side samples
sb.x = edepth(depth,texcoord.xy + vec2(pw,ph)*bord);
sb.y = edepth(depth,texcoord.xy + vec2(-pw,ph)*bord);
sb.z = edepth(depth,texcoord.xy + vec2(pw,0.0)*bord);
sb.w = edepth(depth,texcoord.xy + vec2(0.0,-ph)*bord);

vec4 dda = (2.0* dc - sa - sb) - dtresh;
vec4 ddb = abs(2.0* dc - sa - sb) - (2.0* dc - sa - sb) - dtresh;
dda = vec4(step(dda.x,0.0),step(dda.y,0.0),step(dda.z,0.0),step(dda.w,0.0));
ddb = vec4(step(ddb.x,0.0),step(ddb.y,0.0),step(ddb.z,0.0),step(ddb.w,0.0));

float ea = (clamp(dot(dda,vec4(0.25)),0.0,1.0));
float eb = (clamp(dot(ddb,vec4(0.25)),0.0,1.0));
return color*(0.63+0.37*ea)*(1.37-0.37*eb);
}