#version 120

#define AO 2 //[0 1 2 3]
#define Desaturation
//#define DisableTexture
#define EmissiveRecolor
#define Fog
//#define LightmapBanding
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
#define TranslucentAO 1	//[0 1 2]
#define WaterFog
#define WaterRefraction
//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

#define StrSEnd 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTNormal 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define StrTBright 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

const bool colortex0MipmapEnabled = true;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;
varying float handRecolor;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D colortex7;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform float nightVision;
uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float edepth(sampler2D depth, vec2 coord) {
	return texture2D(depth,coord).r;
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal, float gloss, float visibility)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);	
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

	noise /= pow(max(length(pos),4.0),0.4);
	return noise;
}

vec2 getRefract(vec2 coord, vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec2 newcoord = vec2(xDelta,yDelta)*0.01 + coord;
	float water = texture2D(colortex5, newcoord).g;
	water = float(water > 0.08 && water < 0.12);
	float limit = max(1.0-water,float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0));

	return mix(newcoord,coord,limit);
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither8x8(vec2 pos)
{
	const int ditherPattern[64] = int[64](
		0, 32, 8, 40, 2, 34, 10, 42,
		48, 16, 56, 24, 50, 18, 58, 26,
		12, 44, 4, 36, 14, 46, 6, 38,
		60, 28, 52, 20, 62, 30, 54, 22,
		3, 35, 11, 43, 1, 33, 9, 41,
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

    vec2 positon = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 8.0f));

	int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

	return float(dither) / 64.0f;
}

#include "lib/colorRange.glsl"
#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/ambientOcclusion.glsl"

void main() {
	
	
	vec3 color = rangeExpand(texture2D(colortex0, texcoord.st).rgb);
	vec3 aux = texture2D(colortex5, texcoord.st).rgb;
	float ao = 1.0;
	float spec = texture2D(colortex0, texcoord.st).a;
	vec3 gr = vec3(0.0);
	
	#ifdef LightmapBanding
	aux = vec3(floor(aux.r*16.0)/16.0,aux.g,floor(aux.b*16.0)/16.0);
	#endif
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float torchmap = pow(aux.b,2.2)*0.2 + pow(max(pow(aux.b,2.2)-0.5,0.0)*2.0,5.0);
	float alpha = pow(texture2D(colortex7,texcoord.xy).r,2.2);
	
	float translucent = float(matflag > 0.05);
	float water = float(matflag > 0.08 && matflag < 0.12);
	float particle = float(matflag > 0.18 && matflag < 0.22);
	float hand = float(matflag > 0.38 && matflag < 0.42);	
	
	float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (translucent > 0.9 && alpha > 0.0001) {
		vec3 colorb = pow(max(texture2D(colortex1, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2));
		vec3 normal = texture2D(colortex3, texcoord.st).rgb*2.0-1.0;
		float specemissive = 0.0;
		
		#ifdef DisableTexture
			#ifdef ShadowColor
			colorb = mix(vec3(1.0)*mix(0.4,0.01,water),colorb,float(alpha < 0.98));
			#else
			colorb = vec3(1.0,1.0,1.0)*mix(0.4,0.01,water);
			#endif
		#endif
		
		vec4 worldpos = getWorldPos(fragpos);
		
		#ifdef WaterRefraction
		if (water > 0.9 && isEyeInWater < 0.9){
			vec2 newcoord = getRefract(texcoord.xy,worldpos.xyz+cameraPosition.xyz);
			color = rangeExpand(texture2D(colortex0, newcoord).rgb);
		}
		#endif
		
		color *= mix(vec3(1.0),colorb,pow(alpha,mix(1.0/2.2,1.0,water)));
		
		#ifdef EmissiveRecolor
		if (handRecolor > 0.9 && hand > 0.9){
			float ec = pow(length(colorb),2.8)*4.0;
			colorb = ec*pow(torch_c,vec3(2.2))*0.4+ec*0.35;
			}
		#endif
		
		vec3 finallight = vec3(0);
		vec3 scenelight = vec3(0);
		vec3 torchlight = pow(torch_c,vec3(1.2-0.2*pow(aux.b,0.25)))*torchmap*8.0*mix(1.0,pow(1.0/length(colorb),0.5),water);
		
		#ifdef RPSupport
		#if RPSFormat == 2
		specemissive = pow(texture2D(colortex6,texcoord.xy).b,0.5);
		torchlight += colorb*8.0*specemissive;
		#endif
		#endif
		
		float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
		vec3 uw_tint = mix(vec3(1.0),water_c*0.5,absorb);
		
		float NdotU = pow(dot(normal, upVec)*0.25+0.75,2.2);
		if (particle > 0.9) NdotU = 2.0;
		
		#if TranslucentAO == 1 || TranslucentAO == 2
		#if TranslucentAO == 1
		float aoalpha = 0.98;
		#endif
		#if TranslucentAO == 2
		float aoalpha = 0.01;
		#endif
		
		if (alpha > aoalpha){
			#if AO == 1
			ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
			#if AO == 2
			if (hand < 0.9) ao = dbaoh(depthtex0);
			if (hand > 0.9) ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
			#if AO == 3
			if (hand < 0.9) ao = ssao(depthtex0,normal);
			if (hand > 0.9) ao = dbaol(ao,depthtex0,fragpos.xyz);
			#endif
		}
		#endif
		
		scenelight = vec3(0.05)*ao*StrSEnd;
		finallight = (scenelight*uw_tint+torchlight*ao)*NdotU;
		
		colorb = colorb/sqrt(1.0+colorb*colorb);
		colorb *= finallight;
		
		#ifdef Desaturation
		float desat = clamp(aux.b*1.25+specemissive,0.5,1.0);
		colorb = mix(luma(colorb)*desat_c,colorb,desat);
		#endif
		
		color = mix(color,colorb,alpha);
		
		#ifdef Fog
		if (isEyeInWater < 0.9) color = calcFog(color, fragpos.xyz);
		#endif

	}
	
/* DRAWBUFFERS:0 */
	
	gl_FragData[0] = vec4(rangeCompress(color),spec);

}
