#version 120

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;
varying float handRecolor;

uniform int worldTime;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform int heldItemId;

void main() {
	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0;
	
	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	else {
		lightVector = normalize(-sunPosition);
	}
	sunVec = normalize(sunPosition);
	moonVec = normalize(-sunPosition);
	upVec = normalize(upPosition);
	
	float SdotU = dot(sunVec,upVec);
	float MdotU = dot(moonVec,upVec);
	sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
	moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
	
	handRecolor = 0.0;
	if (heldItemId == 89 || heldItemId == 138 || heldItemId == 169) handRecolor = 1.0;
}
