#version 120

#define Bloom
//#define DOF

const bool colortex0MipmapEnabled = true;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float pi = 3.1415927;

#include "lib/colorRange.glsl"

vec3 makeBloom(float lod,vec2 offset){
vec3 bloom = vec3(0.0);
vec3 temp = vec3(0.0);
float scale = pow(2.0,lod);
vec2 coord = (texcoord.xy-offset)*scale;

if (coord.x > -0.1 && coord.y > -0.1 && coord.x < 1.1 && coord.y < 1.1){
for (int i = 0; i < 7; i++) {
	for (int j = 0; j < 7; j++) {
	float wg = pow((1.0-length(vec2(i-3,j-3))/4.0),2.0)*14.0;
	vec2 bcoord = (texcoord.xy-offset+vec2(i-3,j-3)*pw*vec2(1.0,aspectRatio))*scale;
	if (wg > 0){
		temp = rangeExpand(texture2D(colortex0,bcoord).rgb)*wg;
		bloom += temp;
		}
	}
}
bloom /= 49;
}

return bloom;
}

void main() {

vec3 blur = vec3(0);

#if defined Bloom || defined DOF
 blur += makeBloom(2,vec2(0,0));
 blur += makeBloom(3,vec2(0.3,0));
 blur += makeBloom(4,vec2(0,0.3));
 blur += makeBloom(5,vec2(0.1,0.3));
 blur += makeBloom(6,vec2(0.2,0.3));
 blur += makeBloom(7,vec2(0.3,0.3));
#endif

blur = clamp(rangeCompress(blur),0.0,1.0);

/* DRAWBUFFERS:3 */
	gl_FragData[0] = vec4(blur,1.0);
}
