#version 120

#define Bloom
//#define DirtyLens
#define Vignette

#define BloomStrength 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

//#define DOF
//#define MotionBlur

//#define DOF_Normal
#define DOF_Fog
//#define DOF_Bokeh
//#define DOF_BPrecise
#define DOF_Strength 8							//[4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 128 256 512]
#define DOF_Distance 8							//[2 4 6 8 10 12 14 16 20 24 28 32]
#define DOF_BSize 1.00							//[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
#define DOF_BSide 6								//[6 8 10 14]
#define DOF_BDepth 4							//[4 6 8 12]
#define DOF_BNGon 30							//[3 4 5 6 7 8 12 30]
#define DOF_BCurve 1.00							//[0.25 0.50 0.75 1.00 2.00 3.00 4.00]
#define DOF_BRotate 0							//[-60 -55 -50 -45 -40 -35 -30 -25 -20 -15 -10 -5 0 5 10 15 20 25 30 35 40 45 50 55 60]

#define MotionBlurStrength 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]
	
//#define AverageExposure

#define Tonemap_Scale 3.2 //[2.0 2.4 2.8 3.2 3.6 4.0 4.4]
#define Tonemap_Curve 1.25 //[1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.5]

//#define ColorGrading
//#define ColorGrading_LUT

#define ColR1 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColG1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColB1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColS1 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColC1 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ColR2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColG2 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColB2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColS2 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColC2 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ColR3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColG3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColB3 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColS3 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.9 0.95 1.00]
#define ColC3 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define Brightness 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Saturation 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Contrast 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define Weather
#define WeatherOpacity 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]

//#define WorldTimeAnimation
#define AnimationSpeed 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.50 3.00 3.50 4.00]

/*
FRAGDATA
0 raw solid
1 raw nonsolid
2 solid normals
3 nonsolid normals
4 solid matflag
5 nonsolid matflag
6 specular
7 rain

nonsolid : nonsolid block,water,hand

MATFLAG
.00 sky/sky
.10 none/water
.20 lava/none
.30 metal/none
.40 foliage/hand
.50 emissive/blockindicator
1.0 basic/basic
*/

varying vec4 texcoord;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D colortex0;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#if defined DOF && defined Weather
uniform sampler2D colortex7;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
#ifdef DirtyLens
uniform sampler2D depthtex2;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
#ifdef MotionBlur
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
#endif
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float worldTime;
uniform int isEyeInWater;
uniform float centerDepthSmooth;
#ifdef MotionBlur
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform float frameTime;
#endif
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;

float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0*AnimationSpeed;
#else
float frametime = frameTimeCounter*AnimationSpeed;
#endif

vec2 getRefract(vec2 coord){
vec2 refract = vec2(cos(texcoord.y*32.0+frametime*4.0),sin(texcoord.x*32.0+frametime*4.0))*0.001;

vec2 newcoord = coord + refract*isEyeInWater;
float limit = float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0);

return mix(newcoord,coord,limit);
}

vec3 BSLReinhard(vec3 color){
	vec3 x = color*Tonemap_Scale;
	x = x/sqrt(1.0+x*x);
	return pow(x,vec3(Tonemap_Curve));
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f)+pos*100.0)) * 4378.5453f));
}

#include "lib/colorRange.glsl"
#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"

vec2 angleToVec2(float angle, float pi){
	return vec2(cos(angle*pi/180),sin(angle*pi/180));
}

float getCOC(float z){
	return clamp(abs(z-centerDepthSmooth)/(48.0/DOF_Strength*(1.0+0.5*rainStrength*eBS))-0.1/1280,0,0.00625);
}

void main() {
	const float pi = 22.0/7.0;
	vec2 newcoord = texcoord.xy;
	if (isEyeInWater > 0.9) newcoord = getRefract(texcoord.xy);
	vec3 color = rangeExpand(texture2D(colortex0, newcoord.st).rgb);
	float matflag = texture2D(colortex4, texcoord.st).g;
	float wmatflag = texture2D(colortex5, texcoord.st).g;
	
	float land = float(matflag > 0.08);
	float translucent = float(wmatflag > 0.08);
	float hand = float(wmatflag > 0.38 && wmatflag < 0.42);
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	
	vec3 blur = vec3(0.0);
	vec3 blur1 = vec3(0.0);
	
	#if defined Bloom || defined DOF
	vec2 halfpixel = vec2(1.0/viewWidth,1.0/viewHeight)*0.5;
	const float bpow = 0.25;
		 blur1 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,2.0) + vec2(0.0,0.0)).rgb)*pow(7.0,bpow);
	vec3 blur2 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,3.0) + vec2(0.3,0.0)).rgb)*pow(6.0,bpow);
	vec3 blur3 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,4.0) + vec2(0.0,0.3)).rgb)*pow(5.0,bpow);
	vec3 blur4 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,5.0) + vec2(0.1,0.3)).rgb)*pow(4.0,bpow);
	vec3 blur5 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,6.0) + vec2(0.2,0.3)).rgb)*pow(3.0,bpow);
	vec3 blur6 = rangeExpand(texture2D(colortex3,(newcoord - halfpixel)/pow(2.0,7.0) + vec2(0.3,0.3)).rgb)*pow(2.0,bpow);
	
	blur = (blur1 + blur2 + blur3 + blur4 + blur5 + blur6);
	#endif
	
	//DoF
	float isdof = 0.0;
	#ifdef DOF
	float pixeldepth = texture2D(depthtex0,newcoord.xy).x;
	vec4 fragpos = getFragPos(newcoord,pixeldepth);
	vec4 worldpos = getWorldPos(fragpos);
	worldpos /= worldpos.w;
	
	float pcoc = 0;
	float fog = max(length(worldpos)/(DOF_Distance*128.0),0.0);
	
	vec3 blurcol = clamp(mix(blur1/1.75,blur/8.606,rainStrength*pow(eBS,2.2))*0.44,vec3(0.0),vec3(2.2));
	float fbmix = 0.0;
	float nbmix = 0.0;
	
	#ifdef DOF_Fog
	fbmix = clamp(fog*6*mix(1.0+rainStrength,5.0,isEyeInWater),0.0,1.0)*(mix(max(land,translucent),1.0,isEyeInWater)*(1-rainStrength)+rainStrength);
	#ifndef DOF_Bokeh
	if (fbmix > 0.001) color = mix(color,blurcol,fbmix);
	#endif
	#endif
	
	#ifdef DOF_Normal
	float z = texture2D(depthtex1, newcoord.st).r;
	pcoc = getCOC(z);
	pcoc = pcoc*(1-hand);
	nbmix = pcoc/(0.00625);
	#ifndef DOF_Bokeh
	if (nbmix > 0.001) color = mix(color,blurcol,nbmix);
	#endif
	#endif

	#ifdef DOF_Bokeh
	vec3 bokehcol = texture2DLod(colortex0, newcoord.xy,1).rgb;
	vec3 bokeht = vec3(0);
	float bpcoc = clamp(max(pcoc,pow(fbmix,2.0)*0.00625),0.0,0.00625);
	float rprogress = 90.0;
    float sprogress = 1.0/float(DOF_BDepth);
	float rloops = DOF_BSide;
	float weight = 1.0;
	float sweight = 1.0;
	#ifdef DOF_BPrecise
	float sfog = pow(fbmix,2.0);
	float shand = 1.0;
	float sland = 1.0;
	float stranslucent = 1.0;
	#endif
	
	if (bpcoc > 0.00){
		for (int i = 0; i < DOF_BDepth; i++) {
			for (int j = 0; j < rloops; j++) {
			float sinval = abs(sin((rprogress-90.0+DOF_BRotate)*DOF_BNGon*0.5*pi/180));
			float cosval = mix(pow(cos(pi/DOF_BNGon),DOF_BCurve),1.0,pow(sinval,5.0));
			vec2 offsets = angleToVec2(rprogress,pi)*sprogress*cosval;
			offsets *= bpcoc*DOF_BSize*vec2(1.0,aspectRatio);
			#ifdef DOF_BPrecise
				#ifdef DOF_Normal
				sland = float(texture2D(colortex4,newcoord.st + offsets*normalize(z-centerDepthSmooth)).g > 0.08);
				stranslucent = float(texture2D(colortex5,newcoord.st + offsets*normalize(z-centerDepthSmooth)).g > 0.08);
				sweight = texture2D(depthtex1, newcoord.xy + offsets*max(normalize(z-centerDepthSmooth),rainStrength*(1.0-max(sland,stranslucent))-1.0)).r;
				sweight = getCOC(sweight)/0.00625;
			#endif
			shand = texture2D(colortex5,newcoord.st + offsets).g;
			shand = 1.0-float(shand > 0.38 && shand < 0.42);
			sweight = max(sweight,sfog*(1-pcoc/0.00625))*shand;
			#endif
			bokeht = rangeExpand(texture2D(colortex0, newcoord.xy + offsets).rgb)*pow(cosval,2.0)*sweight;
			bokehcol += bokeht;
			rprogress += 360/rloops;
			if (texcoord.x > offsets.x && texcoord.y > offsets.y && texcoord.x < 1.0-offsets.x && texcoord.y < 1.0-offsets.y)weight += pow(cosval,2.0)*sweight;
			}
		sprogress += 1.0/float(DOF_BDepth);
		rloops += DOF_BSide;
		}
		
	bokehcol /= (weight);
	color = bokehcol;
	}
	#endif
	
	#ifdef Weather
	vec4 rain = texture2D(colortex7,newcoord.xy);
	float raina = rain.a*pow(length(rain.rgb/3.0),0.5)*rainStrength*0.1*WeatherOpacity;
	if (hand < 0.9) color += rain.rgb*raina*(fbmix*(1.0-nbmix));
	#endif
	
	isdof = min(max(fbmix,nbmix)*2.0,1.0);
	#endif
	
	//Motion Blur
	#ifdef MotionBlur
	float motionblur  = texture2D(depthtex1, newcoord.st).x;
	vec3 mblur = rangeExpand(texture2D(colortex0,newcoord.st).rgb);
	float mbwg = 1.0;
	float mbm = 0.0;
	vec2 pixel = 2.0/vec2(viewWidth,viewHeight);
	
	vec4 currentPosition = vec4(newcoord.x * 2.0 - 1.0, newcoord.y * 2.0 - 1.0, 2.0 * motionblur - 1.0, 1.0);
	
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;
	
	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;

	vec2 velocity = (currentPosition - previousPosition).xy;
	velocity = velocity/(1.0+length(velocity))*0.001/frameTime*MotionBlurStrength;
	
	vec2 coord = newcoord.st-velocity*4.0;
	for (int i = 0; i < 9; ++i, coord += velocity) {
		if (hand < 0.9){
			vec2 coordb = clamp(coord,pixel,1.0-pixel);
			vec3 temp = rangeExpand(texture2D(colortex0, coordb).rgb);
			mblur += temp;
			mbwg += 1.0;
		}
	}
	mblur /= mbwg;
	mblur = mix(color,mblur,mbwg/9);

	color = mix(mblur,color,isdof);
	#endif
	
	//Bloom
	#ifdef Bloom
		#ifdef DirtyLens
		float bAR = 1.777777777777778;
		vec3 dirt = texture2D(depthtex2,(texcoord.xy-0.5)/vec2(max(bAR/aspectRatio,1.0),max(aspectRatio/bAR,1.0))+0.5).rgb;
		blur = (blur1 + blur2 + blur3*(1+dirt*pow(length(blur3),1.00)) + blur4*(1+2*dirt*pow(length(blur4),1.05)) + blur5*(1+3*dirt*pow(length(blur5),1.10)) + blur6*(1+4*dirt*pow(length(blur6),1.15)));
		#endif
	color = mix(color,blur,0.02*BloomStrength);
	#endif
	
	//Average Exposure
	#ifdef AverageExposure
	float ae = 8.0*dot(rangeExpand(texture2DLod(colortex0, vec2(0.5),8.5).rgb),vec3(0.299, 0.587, 0.114));
	color *= 0.5+0.5*pow(1.0/ae,1.0/2.2);
	#endif
	
	#ifdef ColorGrading
		#ifdef ColorGrading_LUT
		float pw = 1.0/viewWidth;
		float ph = 1.0/viewHeight;
		if (texcoord.x < 256.0*pw && texcoord.y > 1-16*ph){
			color *= 0;
			color.r = (texcoord.x*viewWidth/16-floor(texcoord.x*viewWidth/16));
			color.g = (1-texcoord.y)*viewHeight/16;
			color.b = floor(texcoord.x*viewWidth/16)/16;
			color = pow(color,vec3(2.2));
		}
		#endif
	vec3 cpcol = (pow(color.r,ColC1)*pow(vec3(ColR1,ColG1,ColB1),vec3(2.2))+pow(color.g,ColC2)*pow(vec3(ColR2,ColG2,ColB2),vec3(2.2))+pow(color.b,ColC3)*pow(vec3(ColR3,ColG3,ColB3),vec3(2.2)));
	vec3 cpmin = pow(vec3(ColM1,ColM2,ColM3),vec3(2.2));
	color = (cpcol*(1-cpmin)+cpmin)*vec3(ColS1,ColS2,ColS3);
	#endif
	
	//Tonemapping
	color = BSLReinhard(color);
	
	//Vignette
	#ifdef Vignette
	color *= 1.0-length(texcoord.xy-0.5)*(1-dot(color*color,vec3(0.299, 0.587, 0.114)));
	#endif
	
	//Final Color Adjustment
	color*= Brightness;
	float gray = 0.0;
	if (Saturation > 1.0) gray = length(color/3);
	else gray = dot(color,vec3(0.299, 0.587, 0.114));
	color = color*Saturation-gray*(Saturation-1.0);
		
	color = clamp(pow(color,vec3(1.0/2.2)),vec3(0.0),vec3(1.0));
	
	color = (color-0.5)*Contrast+0.5;
	
/* DRAWBUFFERS:0 */
	gl_FragData[0] = vec4(color,1.0);

}
