#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;

void main() {
	vec2 adjustedTexCoord = texcoord.st;
	vec3 albedo = texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	
/* DRAWBUFFERS:13567 */

	gl_FragData[0] = vec4(albedo,(texture2D(texture,adjustedTexCoord).a));
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, 0.2, lmcoord.s, 1.0);
	gl_FragData[3] = vec4(0.0,0.0,0.0,1.0);
	gl_FragData[4] = vec4((texture2D(texture,adjustedTexCoord).a),0.0,0.0,1.0);
}