#define FogRange 8 //[2 4 6 8 10 12 14 16 20 24 28 32]

vec3 calcFog(vec3 color, vec3 fragpos){
float fog = min(length(fragpos)/(FogRange*(12)),1.0);
return mix(color, fog_c,fog);
}

vec3 calcWFog(vec3 color, vec3 wcol, float wstr, float fogrange, float nofog, vec3 fragpos){
float fog = min(length(fragpos)/(fogrange*(1.0+3.0*eBS)),1.0);
return mix(color,pow(wcol*pow(wstr,0.75),vec3(2.2)),min(fog,1.0)*max(1.0-nofog,0.0));
}

vec3 calcBFog(vec3 color, float blindness, vec3 fragpos){
	float b = max(blindness*2.0-1.0,0.0);
	b = b*b;
	float fog = pow(min(length(fragpos)/(5.0/b),1.0),1.0/2.2)*b;
	return mix(color,vec3(0.0),fog);
}

vec3 calcLFog(vec3 color, vec3 fragpos){
	float fog = min(length(fragpos)/(2.0),1.0);
	return mix(color,vec3(1.0,0.3,0.01),fog);
}