#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

#define ShadowColor

varying float checkalpha;
varying float disablecolor;
varying vec2 texcoord;
varying vec4 color;

uniform sampler2D tex;

void main() {
	vec4 albedo = texture2D(tex,texcoord.xy)*color;
	
	#ifdef ShadowColor
	//if ((checkalpha > 0.9 && albedo.a > 0.98) || checkalpha < 0.9) albedo.rgb *= 0.0;
	albedo.rgb = mix(vec3(1),albedo.rgb,pow(albedo.a,(1.0-albedo.a)*0.5)*1.05);
	albedo.rgb *= 1.0-pow(albedo.a,64.0);
	#else
	if (checkalpha > 0.9 && albedo.a < 0.98) albedo.a*= 0.0;
	#endif
	if (disablecolor > 0.9) albedo.a *= 0.0;
	
	gl_FragData[0] = albedo;
	
}