#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

//#define AutoExposure
#define Bloom
//#define ColorGrading
//#define ColorAdjustment
//#define DOF
#define Vignette

#ifdef AutoExposure
const bool colortex0MipmapEnabled = true;
#endif
const bool colortex2Clear = false;

varying vec3 upVec;
varying vec3 sunVec;

varying vec2 texcoord;

uniform int isEyeInWater;
uniform int worldTime;

uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float frameTimeCounter;

uniform ivec2 eyeBrightnessSmooth;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D noisetex;

#ifdef DOF
uniform float centerDepthSmooth;
#endif

uniform sampler2D depthtex1;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);
float moonVisibility = pow(clamp(dot(-sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);
float pw = 1.0/viewWidth;
float ph = 1.0/viewHeight;

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float temporalMix(float temporal, float fade, float x){
	return temporal * (1.0-fade) + fade * x;
}


#ifdef Bloom
#include "lib/post/bloom.glsl"
#endif
#ifdef ColorAdjustment
#include "lib/post/colorAdjustment.glsl"
#endif
#ifdef ColorGrading
#include "lib/post/colorGrading.glsl"
#endif
#ifdef DOF
#include "lib/post/depthOfField.glsl"
#endif
#include "lib/post/tonemap.glsl"

void main() {
	vec3 color = texture2D(colortex0,texcoord.xy).rgb;
	
	//Temporal Stuffs
	float tempexposure = texture2D(colortex2,vec2(pw,ph)).r;
	
	//Material Flag
	float hand = float(texture2D(depthtex1,texcoord.xy).r < 0.56);
	
	//Depth of Field
	float coc = 0.0;
	#ifdef DOF
	coc = getCoC();
	color = depthOfField(color,coc,hand);
	coc = min(coc*coc*16.0,1.0);
	#endif
	
	//Bloom
	#ifdef Bloom
	color = bloom(color);
	#endif
	
	//Auto Exposure
	#ifdef AutoExposure
	float exposure = clamp(length(texture2DLod(colortex0,vec2(0.5),log2(viewWidth*0.4)).rgb),0.0001,10.0);
	color.rgb /= sqrt(4.0*clamp(tempexposure,0.0001,10.0));
	#endif
	
	//Color Grading
	#ifdef ColorGrading
	color = colorGrading(color);
	#endif
	
	//Tonemap
	color = BSLTonemap(color);
	
	//Vignette
	#ifdef Vignette
	color *= 1.0-length(texcoord.xy-0.5)*(1-luma(color*color));
	#endif
	
	//Final Color Adjustment
	#ifdef ColorAdjustment
	color = colorAdjustment(color);
	#endif
	
	//Store Temporal Values;
	float temporal = 0.0;
	#ifdef AutoExposure
	if (texcoord.x < 2*pw && texcoord.y < 2*ph) temporal = temporalMix(tempexposure,0.05,exposure);
	#endif
	
	color = pow(color,vec3(1.0/2.2));
	color += (texture2D(noisetex,texcoord.xy*vec2(aspectRatio,1.0)+4.0*frameTimeCounter).rgb*2.0-1.0)/128.0;
	
/*DRAWBUFFERS:12*/
	gl_FragData[0] = vec4(color,1.0);
	gl_FragData[1] = vec4(temporal,0.0,0.0,0.0);
}