#define AORadius 0 //[0 1 2]
float dither5x3()
{
	const int ditherPattern[15] = int[15](
		 9, 3, 7,12, 0,
		11, 5, 1,14, 8,
		 2,13,10, 4, 6);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), vec2(5.0,3.0)));

	int dither = ditherPattern[int(position.x) + int(position.y) * 5];

	return float(dither) / 15.0f;
}

float dbao(sampler2D depth, float dither){
	float ao = 0.0;
	
	const int aoloop = 2*AORadius+3;
	const int aoside = 2*AORadius+6;
	float radius = 0.1;
	for(int i=0;i<AORadius;i++) radius *= 0.5;
	float dither2 = fract(dither5x3()-dither);
	float d = ld(texture2D(depth,texcoord.xy).r);
	const float piangle = 0.0174603175;
	float rot = (360.0/aoside)*(dither2+0.5)+90.0;
	float size = radius*dither;
	float sd = 0.0;
	float angle = 0.0;
	float dist = 0.0;
	vec2 scale = vec2(1.0/aspectRatio,1.0) * gbufferProjection[1][1] / (1.37373871 * max(far*d,4.0));
	
	for (int i = 0; i < aoloop; i++) {
		for (int j = 0; j < aoside; j++) {
			sd = ld(texture2D(depth,texcoord.xy+vec2(cos(rot*piangle),sin(rot*piangle)) * size * scale).r);
			angle += clamp(1.0-2.0/radius*far*(d-sd),0.0,2.0);
			dist += clamp(0.25/radius*far*(d-sd),0.0,2.0);
			rot += 360.0/aoside;
		}
		rot += 180.0/aoside;
		size = radius*dither+radius;
		radius += radius;
		ao += clamp((angle+dist)/aoside,0.0,1.0);
		angle = 0.0;
		dist = 0.0;
	}
	
	ao /= aoloop;
	
	return pow(ao,0.5*AORadius+1.5);
}